"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntries = entityOrInfluencer => {
  const entries = Object.entries(entityOrInfluencer);
  if (Array.isArray(entries[0])) {
    const [[key, value]] = entries;
    return [key, value];
  } else {
    return [null, null];
  }
};
exports.getEntries = getEntries;