"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAggregatedAnomaliesByJob = exports.AnomalyEntity = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _query = require("../../../../entity_analytics/components/entity_analytics_anomalies/query");
var _constants = require("../../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../lib/kibana");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _anomalies_search = require("../api/anomalies_search");
var _use_security_jobs = require("../../ml_popover/hooks/use_security_jobs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AnomalyEntity = exports.AnomalyEntity = /*#__PURE__*/function (AnomalyEntity) {
  AnomalyEntity[AnomalyEntity["User"] = 0] = "User";
  AnomalyEntity[AnomalyEntity["Host"] = 1] = "Host";
  return AnomalyEntity;
}({});
const useAggregatedAnomaliesByJob = ({
  skip,
  from,
  to
}) => {
  const [data, setData] = (0, _react.useState)([]);
  const {
    loading: jobsLoading,
    isMlAdmin: isMlUser,
    jobs: securityJobs,
    refetch: refetchJobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  const [loading, setLoading] = (0, _react.useState)(true);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [anomalyScoreThreshold] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_ANOMALY_SCORE);
  const {
    query
  } = (0, _react.useMemo)(() => ({
    query: (0, _query.getAggregatedAnomaliesQuery)({
      jobIds: securityJobs.map(({
        id
      }) => id),
      anomalyScoreThreshold,
      from,
      to
    })
  }), [securityJobs, anomalyScoreThreshold, from, to]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    async function fetchAnomaliesSearch() {
      if (!isSubscribed) return;
      if (skip || !isMlUser || securityJobs.length === 0) {
        setLoading(false);
        return;
      }
      setLoading(true);
      try {
        const response = await (0, _anomalies_search.anomaliesSearch)({
          jobIds: securityJobs.filter(job => job.isInstalled).map(({
            id
          }) => id),
          query
        }, abortCtrl.signal);
        if (isSubscribed) {
          var _response$aggregation, _response$aggregation2;
          setLoading(false);
          const buckets = (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.number_of_anomalies.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
          setData(formatResultData(buckets, securityJobs));
        }
      } catch (error) {
        if (isSubscribed && error.name !== 'AbortError') {
          addError(error, {
            title: i18n.SIEM_TABLE_FETCH_FAILURE
          });
          setLoading(false);
        }
      }
    }
    fetchAnomaliesSearch();
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [skip, isMlUser, addError, query, securityJobs, refetchJobs]);
  return {
    isLoading: loading || jobsLoading,
    data,
    refetch: refetchJobs
  };
};
exports.useAggregatedAnomaliesByJob = useAggregatedAnomaliesByJob;
function formatResultData(buckets, anomaliesJobs) {
  const unsortedAnomalies = anomaliesJobs.map(job => {
    var _job$customSettings$s, _job$customSettings, _bucket$doc_count;
    const bucket = buckets.find(({
      key
    }) => key === (job === null || job === void 0 ? void 0 : job.id));
    const hasUserName = (0, _fp.has)("entity.hits.hits[0].fields['user.name']", bucket);
    return {
      name: (_job$customSettings$s = job === null || job === void 0 ? void 0 : (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name) !== null && _job$customSettings$s !== void 0 ? _job$customSettings$s : job.id,
      count: (_bucket$doc_count = bucket === null || bucket === void 0 ? void 0 : bucket.doc_count) !== null && _bucket$doc_count !== void 0 ? _bucket$doc_count : 0,
      entity: hasUserName ? AnomalyEntity.User : AnomalyEntity.Host,
      job
    };
  });
  return (0, _fp.sortBy)(['name'], unsortedAnomalies);
}