"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPinTooltipContent = exports.eventHasNotes = exports.TOOLTIP_TEST_ID = exports.PinEventAction = exports.BUTTON_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _selectors = require("../../../timelines/store/selectors");
var _styles = require("../../../timelines/components/timeline/styles");
var _timeline = require("../../../../common/api/timeline");
var _user_privileges = require("../user_privileges");
var _ = require(".");
var _store = require("../../../timelines/store");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/header_actions/pin_event_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_TEST_ID = exports.BUTTON_TEST_ID = 'timeline-pin-event-button';
const TOOLTIP_TEST_ID = exports.TOOLTIP_TEST_ID = 'timeline-action-pin-tool-tip';

/**
 * Returns true if the noteIds array is not empty
 */
const eventHasNotes = noteIds => !(0, _fp.isEmpty)(noteIds);

/**
 * Returns the tooltip content based on timeline type, pin state, note ids and the fact that the document is an alert or not
 */
exports.eventHasNotes = eventHasNotes;
const getPinTooltipContent = (isAlert, isPinned, noteIds, timelineType) => {
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return i18n.DISABLE_PIN(isAlert);
  } else if (eventHasNotes(noteIds)) {
    return i18n.PINNED_WITH_NOTES(isAlert);
  } else if (isPinned) {
    return i18n.PINNED(isAlert);
  } else {
    return i18n.UNPINNED(isAlert);
  }
};
exports.getPinTooltipContent = getPinTooltipContent;
/**
 * Component rendering a pin icon button to pin/unpin an alert or event in a timeline
 */
const PinEventAction = exports.PinEventAction = /*#__PURE__*/(0, _react.memo)(({
  ariaRowindex,
  columnValues,
  eventId,
  eventIdToNoteIds,
  isAlert,
  noteIds,
  timelineId,
  timelineType
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timelinePrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const isPinnedSelector = (0, _react.useMemo)(() => (0, _selectors.selectIsPinnedEventInTimeline)(), []);
  const isPinned = (0, _reactRedux.useSelector)(state => isPinnedSelector(state, timelineId, eventId));
  const tooltipContent = (0, _react.useMemo)(() => getPinTooltipContent(isAlert, isPinned, noteIds, timelineType), [timelineType, noteIds, isPinned, isAlert]);
  const handlePinClicked = (0, _react.useCallback)(() => {
    const allowUnpinning = eventIdToNoteIds ? !eventHasNotes(eventIdToNoteIds[eventId]) : true;
    if (!allowUnpinning) {
      return;
    }
    if (isPinned) {
      dispatch(_store.timelineActions.unPinEvent({
        id: timelineId,
        eventId
      }));
    } else {
      dispatch(_store.timelineActions.pinEvent({
        id: timelineId,
        eventId
      }));
    }
  }, [eventIdToNoteIds, eventId, isPinned, dispatch, timelineId]);
  const ariaLabel = (0, _react.useMemo)(() => timelineType === _timeline.TimelineTypeEnum.template ? i18n.DISABLE_PIN(isAlert) : i18n.PIN_EVENT_FOR_ROW({
    ariaRowindex,
    columnValues,
    isPinned
  }), [ariaRowindex, columnValues, isAlert, isPinned, timelineType]);
  const isDisabled = (0, _react.useMemo)(() => !timelinePrivileges.crud || timelineType === _timeline.TimelineTypeEnum.template || eventHasNotes(noteIds), [noteIds, timelinePrivileges.crud, timelineType]);
  return /*#__PURE__*/_react.default.createElement("div", {
    key: "timeline-action-pin-tool-tip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _.DEFAULT_ACTION_BUTTON_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": TOOLTIP_TEST_ID,
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": ariaLabel,
    "data-test-subj": BUTTON_TEST_ID,
    isDisabled: isDisabled,
    iconType: isPinned ? 'pinFilled' : 'pin',
    onClick: handlePinClicked,
    size: "s",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }))));
});
PinEventAction.displayName = 'PinEventAction';