"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateInTimelineButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../detections/components/alerts_table/translations");
var _user_privileges = require("../user_privileges");
var _use_investigate_in_timeline = require("../../hooks/timeline/use_investigate_in_timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/event_details/investigate_in_timeline_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component that renders a EuiEmptyButton or a normal EuiButton to wrap some content and attaches a
 * investigate in timeline callback to the click event.
 */
const InvestigateInTimelineButton = ({
  asEmptyButton,
  children,
  dataProviders,
  filters,
  timeRange,
  keepDataView,
  iconType,
  flush,
  isDisabled,
  'data-test-subj': dataTestSubj,
  ...rest
}) => {
  const {
    investigateInTimeline
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)();
  const openTimelineCallback = (0, _react.useCallback)(() => {
    investigateInTimeline({
      dataProviders,
      filters,
      timeRange,
      keepDataView
    });
  }, [dataProviders, filters, timeRange, keepDataView, investigateInTimeline]);
  const {
    timelinePrivileges: {
      read: canUseTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const disabled = !canUseTimeline || isDisabled;
  return asEmptyButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.ACTION_INVESTIGATE_IN_TIMELINE,
    onClick: openTimelineCallback,
    flush: flush !== null && flush !== void 0 ? flush : 'right',
    size: "xs",
    iconType: iconType,
    disabled: disabled,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "aria-label": _translations.ACTION_INVESTIGATE_IN_TIMELINE,
    disabled: disabled,
    onClick: openTimelineCallback,
    "data-test-subj": dataTestSubj
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }), children);
};
exports.InvestigateInTimelineButton = InvestigateInTimelineButton;
InvestigateInTimelineButton.displayName = 'InvestigateInTimelineButton';