"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableBadge = exports.Badge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _cell_actions_renderer = require("../cell_actions/cell_actions_renderer");
var _empty_value = require("../empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/draggables/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Badge = exports.Badge = (0, _styled.default)(_eui.EuiBadge)`
  vertical-align: top;
`;
Badge.displayName = 'Badge';
/**
 * A draggable badge that's only displayed when the specified value is non-`null`.
 *
 * @param field - the name of the field, e.g. `network.transport`
 * @param value - value of the field e.g. `tcp`
 * @param iconType -the (optional) type of icon e.g. `snowflake` to display on the badge
 * @param name - defaulting to `field`, this optional human readable name is used by the `DataProvider` that represents the data
 * @param children - defaults to displaying `value`, this allows an arbitrary visualization to be displayed in lieu of the default behavior
 * @param tooltipContent - defaults to displaying `field`, pass `null` to
 * prevent a tooltip from being displayed, or pass arbitrary content
 * @param queryValue - defaults to `value`, this query overrides the `queryMatch.value` used by the `DataProvider` that represents the data
 */
const DraggableBadgeComponent = ({
  field,
  value,
  iconType,
  children,
  scopeId,
  tooltipContent,
  queryValue
}) => value != null ? /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
  field: field,
  value: value,
  scopeId: scopeId,
  tooltipContent: tooltipContent,
  queryValue: queryValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(Badge, {
  iconType: iconType,
  color: "hollow",
  title: "",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 7
  }
}, children ? children : value !== '' ? value : (0, _empty_value.getEmptyStringTag)())) : null;
DraggableBadgeComponent.displayName = 'DraggableBadgeComponent';
const DraggableBadge = exports.DraggableBadge = /*#__PURE__*/_react.default.memo(DraggableBadgeComponent);
DraggableBadge.displayName = 'DraggableBadge';