"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableLegendItem = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _constants = require("../../../../common/constants");
var _cell_actions_renderer = require("../cell_actions/cell_actions_renderer");
var _kibana = require("../../lib/kibana");
var _translation = require("./translation");
var _validators = require("../../utils/validators");
var _cell_actions = require("../cell_actions");
var _helpers = require("../../../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/charts/draggable_legend_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CountFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `margin-right: ${theme.euiTheme.size.s};`}
`;
/**
 * Renders the value or a placeholder in case the value is empty
 */
const ValueWrapper = /*#__PURE__*/_react.default.memo(({
  value
}) => (0, _validators.hasValueToDisplay)(value) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value) : /*#__PURE__*/_react.default.createElement("em", {
  "data-test-subj": "value-wrapper-empty",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 5
  }
}, _translation.EMPTY_VALUE_LABEL));
ValueWrapper.displayName = 'ValueWrapper';
const DraggableLegendItemComponent = ({
  legendItem,
  isInlineActions = false
}) => {
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const {
    color,
    count,
    field,
    scopeId,
    value
  } = legendItem;
  const sourcererScopeId = (0, _helpers.getSourcererScopeId)(scopeId !== null && scopeId !== void 0 ? scopeId : '');
  const content = (0, _react.useMemo)(() => {
    return legendItem.render == null ? /*#__PURE__*/_react.default.createElement(ValueWrapper, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    }) : legendItem.render({
      field,
      value
    });
  }, [field, value, legendItem]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, color != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "legend-color",
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": 'legend-item',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, isInlineActions ? content : /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    field: field,
    hideTopN: true,
    scopeId: scopeId,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  }, content)), count != null && /*#__PURE__*/_react.default.createElement(CountFlexItem, {
    "data-test-subj": "legendItemCount",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, (0, _numeral.default)(count).format(defaultNumberFormat)))), isInlineActions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "legendItemInlineActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    mode: _cell_actions.CellActionsMode.INLINE,
    visibleCellActions: 0,
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    data: {
      field,
      value
    },
    sourcererScopeId: sourcererScopeId,
    metadata: {
      scopeId
    },
    disabledActionTypes: [_cell_actions.SecurityCellActionType.SHOW_TOP_N],
    extraActionsIconType: "boxesVertical",
    extraActionsColor: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }))));
};
DraggableLegendItemComponent.displayName = 'DraggableLegendItemComponent';
const DraggableLegendItem = exports.DraggableLegendItem = /*#__PURE__*/_react.default.memo(DraggableLegendItemComponent);