"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarChartComponent = exports.BarChartBaseComponent = exports.BarChartBase = exports.BarChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _fp = require("lodash/fp");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _kibana = require("../../lib/kibana");
var _utils = require("../utils");
var _validators = require("../../utils/validators");
var _translation = require("./translation");
var _chart_place_holder = require("./chart_place_holder");
var _common = require("./common");
var _draggable_legend = require("./draggable_legend");
var _actions = require("../visualization_actions/actions");
var _hover_visibility_container = require("../hover_visibility_container");
var _utils2 = require("../visualization_actions/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/charts/barchart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LegendFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  overview: hidden;
`;
const checkIfAllTheDataInTheSeriesAreValid = series => series != null && !!(0, _fp.get)('value.length', series) && (series.value || []).every(({
  x,
  y
}) => (0, _fp.isNumber)(y) && y >= 0);
const checkIfAnyValidSeriesExist = data => Array.isArray(data) && !(0, _common.checkIfAllValuesAreZero)(data) && data.some(checkIfAllTheDataInTheSeriesAreValid);
const yAccessors = ['y'];
const splitSeriesAccessors = [datum => (0, _validators.hasValueToDisplay)(datum.g) ? datum.g : _translation.EMPTY_VALUE_LABEL];

// Bar chart rotation: https://ela.st/chart-rotations
const BarChartBaseComponent = ({
  data,
  forceHiddenLegend = false,
  yAxisTitle,
  ...chartConfigs
}) => {
  const themes = (0, _common.useThemes)();
  const timeZone = (0, _kibana.useTimeZone)();
  const xTickFormatter = (0, _fp.get)('configs.axis.xTickFormatter', chartConfigs);
  const yTickFormatter = (0, _fp.get)('configs.axis.yTickFormatter', chartConfigs);
  const tickSize = (0, _fp.getOr)(0, 'configs.axis.tickSize', chartConfigs);
  const xAxisId = `stat-items-barchart-${data[0].key}-x`;
  const yAxisId = `stat-items-barchart-${data[0].key}-y`;
  const settings = {
    ..._common.chartDefaultSettings,
    ...(0, _deepmerge.default)((0, _fp.get)('configs.settings', chartConfigs), themes)
  };
  const xAxisStyle = (0, _react.useMemo)(() => (0, _deepmerge.default)({
    tickLine: {
      size: tickSize
    }
  }, (0, _fp.getOr)({}, 'configs.axis.bottom.style', chartConfigs)), [chartConfigs, tickSize]);
  const yAxisStyle = (0, _react.useMemo)(() => (0, _deepmerge.default)({
    tickLine: {
      size: tickSize
    }
  }, (0, _fp.getOr)({}, 'configs.axis.left.style', chartConfigs)), [chartConfigs, tickSize]);
  const xAxisLabelFormat = (0, _fp.get)('configs.axis.bottom.labelFormat', chartConfigs);
  return chartConfigs.width && chartConfigs.height ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({}, settings, {
    showLegend: settings.showLegend && !forceHiddenLegend,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  })), data.map(series => {
    var _series$value;
    const barSeriesKey = series.key;
    return checkIfAllTheDataInTheSeriesAreValid(series) ? /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: barSeriesKey,
      key: barSeriesKey,
      name: series.key,
      xScaleType: (0, _fp.getOr)(_charts.ScaleType.Linear, 'configs.series.xScaleType', chartConfigs),
      yScaleType: (0, _fp.getOr)(_charts.ScaleType.Linear, 'configs.series.yScaleType', chartConfigs),
      xAccessor: "x",
      yAccessors: yAccessors,
      timeZone: timeZone,
      splitSeriesAccessors: splitSeriesAccessors,
      data: (_series$value = series.value) !== null && _series$value !== void 0 ? _series$value : [],
      stackAccessors: (0, _fp.get)('configs.series.stackAccessors', chartConfigs),
      color: series.color ? series.color : undefined,
      barSeriesStyle: (0, _fp.get)('configs.series.barSeriesStyle', chartConfigs),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }) : null;
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: xAxisId,
    position: _charts.Position.Bottom,
    showOverlappingTicks: false,
    style: xAxisStyle,
    tickFormat: xTickFormatter,
    labelFormat: xAxisLabelFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: yAxisId,
    position: _charts.Position.Left,
    style: yAxisStyle,
    tickFormat: yTickFormatter,
    title: yAxisTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  })) : null;
};
exports.BarChartBaseComponent = BarChartBaseComponent;
BarChartBaseComponent.displayName = 'BarChartBaseComponent';
const BarChartBase = exports.BarChartBase = /*#__PURE__*/_react.default.memo(BarChartBaseComponent);
BarChartBase.displayName = 'BarChartBase';
const NO_LEGEND_DATA = [];
const BarChartComponent = ({
  barChart,
  configs,
  stackByField,
  scopeId,
  visualizationActionsOptions
}) => {
  const {
    ref: measureRef,
    width,
    height
  } = (0, _utils.useThrottledResizeObserver)();
  const legendItems = (0, _react.useMemo)(() => barChart != null && stackByField != null ? barChart.map(d => ({
    color: d.color,
    scopeId,
    field: stackByField,
    value: d.key
  })) : NO_LEGEND_DATA, [barChart, stackByField, scopeId]);
  const yAxisTitle = (0, _fp.get)('yAxisTitle', configs);
  const customHeight = (0, _fp.get)('customHeight', configs);
  const customWidth = (0, _fp.get)('customWidth', configs);
  const chartHeight = (0, _common.getChartHeight)(customHeight, height);
  const chartWidth = (0, _common.getChartWidth)(customWidth, width);
  const isValidSeriesExist = (0, _react.useMemo)(() => checkIfAnyValidSeriesExist(barChart), [barChart]);
  return /*#__PURE__*/_react.default.createElement(_common.Wrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    targetClassNames: [_utils2.VISUALIZATION_ACTIONS_BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }, isValidSeriesExist && barChart && /*#__PURE__*/_react.default.createElement(_common.BarChartWrapper, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_common.WrappedByAutoSizer, {
    ref: measureRef,
    height: chartHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(BarChartBase, {
    configs: configs,
    data: barChart,
    yAxisTitle: yAxisTitle,
    forceHiddenLegend: stackByField != null,
    height: chartHeight,
    width: chartHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(LegendFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_draggable_legend.DraggableLegend, {
    legendItems: legendItems,
    height: height,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }))), !isValidSeriesExist && /*#__PURE__*/_react.default.createElement(_chart_place_holder.ChartPlaceHolder, {
    height: chartHeight,
    width: chartWidth,
    data: barChart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }), visualizationActionsOptions != null && /*#__PURE__*/_react.default.createElement(_actions.VisualizationActions, (0, _extends2.default)({}, visualizationActionsOptions, {
    className: "viz-actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }))));
};
exports.BarChartComponent = BarChartComponent;
const BarChart = exports.BarChart = /*#__PURE__*/_react.default.memo(BarChartComponent, (prevProps, nextProps) => prevProps.stackByField === nextProps.stackByField && prevProps.scopeId === nextProps.scopeId && (0, _fastDeepEqual.default)(prevProps.configs, nextProps.configs) && (0, _fastDeepEqual.default)(prevProps.barChart, nextProps.barChart));