"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tooltipContentIsExplicitlyNull = exports.getDefaultWhenTooltipIsUnspecified = exports.disableHoverActions = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../timelines/components/row_renderers_browser/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines if hover actions should be disabled for a given timeline ID
 * @param timelineId - The timeline ID to check
 * @returns true if hover actions should be disabled, false otherwise
 */
const disableHoverActions = timelineId => [_securitysolutionDataTable.TableId.rulePreview, _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID].includes(timelineId !== null && timelineId !== void 0 ? timelineId : '');

/**
 * Only returns true if the specified tooltipContent is exactly `null`.
 * Example input / output:
 * `bob -> false`
 * `undefined -> false`
 * `<span>thing</span> -> false`
 * `null -> true`
 */
exports.disableHoverActions = disableHoverActions;
const tooltipContentIsExplicitlyNull = tooltipContent => tooltipContent === null; // an explicit / exact null check

/**
 * Derives the tooltip content from the field name if no tooltip was specified
 */
exports.tooltipContentIsExplicitlyNull = tooltipContentIsExplicitlyNull;
const getDefaultWhenTooltipIsUnspecified = ({
  field,
  tooltipContent
}) => tooltipContent != null ? tooltipContent : field;
exports.getDefaultWhenTooltipIsUnspecified = getDefaultWhenTooltipIsUnspecified;