"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateEntityInsight = void 0;
var _expandableFlyout = require("@kbn/expandable-flyout");
var _react = require("react");
var _use_has_vulnerabilities = require("@kbn/cloud-security-posture/src/hooks/use_has_vulnerabilities");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _user_details_left = require("../../flyout/entity_details/user_details_left");
var _host_details_left = require("../../flyout/entity_details/host_details_left");
var _left_panel_header = require("../../flyout/entity_details/shared/components/left_panel/left_panel_header");
var _use_global_time = require("../../common/containers/use_global_time");
var _types = require("../../overview/components/detection_response/alerts_by_status/types");
var _use_non_closed_alerts = require("./use_non_closed_alerts");
var _use_risk_score_data = require("./use_risk_score_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateEntityInsight = ({
  field,
  value,
  subTab,
  queryIdExtension
}) => {
  const isHostNameField = field === 'host.name';
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field,
    value,
    to,
    from,
    queryId: `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}${queryIdExtension}`
  });
  const {
    hasVulnerabilitiesFindings
  } = (0, _use_has_vulnerabilities.useHasVulnerabilities)(field, value);
  const {
    hasRiskScore
  } = (0, _use_risk_score_data.useHasRiskScore)({
    field,
    value
  });
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(field, value);
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const goToEntityInsightTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: isHostNameField ? _host_details_left.HostDetailsPanelKey : _user_details_left.UserDetailsPanelKey,
      params: isHostNameField ? {
        name: value,
        isRiskScoreExist: hasRiskScore,
        hasMisconfigurationFindings,
        hasVulnerabilitiesFindings,
        hasNonClosedAlerts,
        path: {
          tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
          subTab
        }
      } : {
        user: {
          name: value
        },
        isRiskScoreExist: hasRiskScore,
        hasMisconfigurationFindings,
        hasNonClosedAlerts,
        path: {
          tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
          subTab
        }
      }
    });
  }, [openLeftPanel, isHostNameField, value, hasRiskScore, hasMisconfigurationFindings, hasVulnerabilitiesFindings, hasNonClosedAlerts, subTab]);
  return {
    goToEntityInsightTab
  };
};
exports.useNavigateEntityInsight = useNavigateEntityInsight;