"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _expandable_panel = require("../../../flyout/shared/components/expandable_panel");
var _helpers = require("../../../detections/components/alerts_kpis/severity_level_panel/helpers");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_security_posture/components/alerts/alerts_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertsCount = ({
  alertsTotal,
  euiTheme
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": 'securitySolutionFlyoutInsightsAlertsCount',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(alertsTotal)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.alerts.alertsCountDescription",
    defaultMessage: "Alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  })))));
};
const AlertsPreview = ({
  alertsData,
  isPreviewMode,
  openDetailsPanel
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const severityMap = new Map();
  const severityRank = {
    critical: 4,
    high: 3,
    medium: 2,
    low: 1
  };
  Object.keys(alertsData || {}).forEach(status => {
    var _alertsData$status;
    if (alertsData !== null && alertsData !== void 0 && (_alertsData$status = alertsData[status]) !== null && _alertsData$status !== void 0 && _alertsData$status.severities) {
      var _alertsData$status2;
      alertsData === null || alertsData === void 0 ? void 0 : (_alertsData$status2 = alertsData[status]) === null || _alertsData$status2 === void 0 ? void 0 : _alertsData$status2.severities.forEach(severity => {
        const currentSeverity = severityMap.get(severity.key) || 0;
        severityMap.set(severity.key, currentSeverity + severity.value);
      });
    }
  });
  const alertStats = Array.from(severityMap, ([key, count]) => ({
    key: (0, _lodash.capitalize)(key),
    count,
    color: (0, _helpers.getSeverityColor)(key, euiTheme),
    sort: severityRank[key.toLowerCase()] || 0
  })).sort((a, b) => b.sort - a.sort);
  const totalAlertsCount = alertStats.reduce((total, item) => total + item.count, 0);
  const hasNonClosedAlerts = totalAlertsCount > 0;
  const goToEntityInsightTab = (0, _react.useCallback)(() => openDetailsPanel({
    tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
    subTab: _left_panel_header.CspInsightLeftPanelSubTab.ALERTS
  }), [openDetailsPanel]);
  const link = (0, _react.useMemo)(() => ({
    callback: goToEntityInsightTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.alerts.alertsTooltip",
      defaultMessage: "Show all alerts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    })
  }), [goToEntityInsightTab]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      iconType: !isPreviewMode && hasNonClosedAlerts ? 'arrowStart' : '',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        css: {
          fontWeight: euiTheme.font.weight.bold
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.alerts.alertsTitle",
        defaultMessage: "Alerts",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 13
        }
      })),
      link: totalAlertsCount > 0 ? link : undefined
    },
    "data-test-subj": 'securitySolutionFlyoutInsightsAlerts',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AlertsCount, {
    alertsTotal: totalAlertsCount,
    euiTheme: euiTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: alertStats,
    "data-test-subj": "AlertsPreviewDistributionBarTestId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  }))))));
};
exports.AlertsPreview = AlertsPreview;