"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetMissingIndexPrivileges = void 0;
var _reactQuery = require("@kbn/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_MINUTE = 60000;
const DEFAULT_QUERY_OPTIONS = {
  refetchIntervalInBackground: false,
  staleTime: ONE_MINUTE * 5,
  retry: false
};

/** Retrieves the attack discovery schedule. */
const getMissingIndexPrivileges = async signal => {
  const version = _elasticAssistantCommon.API_VERSIONS.internal.v1;
  return _kibana.KibanaServices.get().http.get(_elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_MISSING_PRIVILEGES, {
    version,
    signal
  });
};
const useGetMissingIndexPrivileges = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['GET', _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_MISSING_PRIVILEGES], async ({
    signal
  }) => getMissingIndexPrivileges(signal), {
    ...DEFAULT_QUERY_OPTIONS,
    onError: error => {
      addError(error, {
        title: i18n.GET_ATTACK_DISCOVERY_MISSING_PRIVILEGES_FAILURE
      });
    }
  });
};
exports.useGetMissingIndexPrivileges = useGetMissingIndexPrivileges;