"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAttackDiscoverySchedule = exports.getAttackDiscoverySchedule = exports.findAttackDiscoverySchedule = exports.fetchRuleTypes = exports.enableAttackDiscoverySchedule = exports.disableAttackDiscoverySchedule = exports.deleteAttackDiscoverySchedule = exports.createAttackDiscoverySchedule = exports.ALERTING_RULE_TYPES_URL = void 0;
var _shared = require("@kbn/openapi-common/shared");
var _common = require("@kbn/alerting-plugin/common");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _kibana = require("../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTING_RULE_TYPES_URL = exports.ALERTING_RULE_TYPES_URL = `${_common.BASE_ALERTING_API_PATH}/rule_types`;
/** Creates a new attack discovery schedule with the provided attributes. */
const createAttackDiscoverySchedule = async ({
  body,
  signal
}) => {
  // Transform from frontend camelCase to API snake_case
  const requestBody = (0, _elasticAssistantCommon.transformAttackDiscoveryScheduleCreatePropsToApi)(body);
  return _kibana.KibanaServices.get().http.post(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES, {
    body: JSON.stringify(requestBody),
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    signal
  });
};
exports.createAttackDiscoverySchedule = createAttackDiscoverySchedule;
/** Retrieves the attack discovery schedule. */
const getAttackDiscoverySchedule = async ({
  id,
  signal
}) => {
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID, {
    id
  }), {
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    signal
  });
};
exports.getAttackDiscoverySchedule = getAttackDiscoverySchedule;
/** Updates the attack discovery schedule. */
const updateAttackDiscoverySchedule = async ({
  id,
  body,
  signal
}) => {
  // Transform from frontend camelCase to API snake_case
  const requestBody = (0, _elasticAssistantCommon.transformAttackDiscoveryScheduleUpdatePropsToApi)(body);
  return _kibana.KibanaServices.get().http.put((0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID, {
    id
  }), {
    body: JSON.stringify(requestBody),
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    signal
  });
};
exports.updateAttackDiscoverySchedule = updateAttackDiscoverySchedule;
/** Deletes the attack discovery schedule. */
const deleteAttackDiscoverySchedule = async ({
  id,
  signal
}) => {
  return _kibana.KibanaServices.get().http.delete((0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID, {
    id
  }), {
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    signal
  });
};
exports.deleteAttackDiscoverySchedule = deleteAttackDiscoverySchedule;
/** Enables the attack discovery schedule. */
const enableAttackDiscoverySchedule = async ({
  id,
  signal
}) => {
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID_ENABLE, {
    id
  }), {
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    signal
  });
};
exports.enableAttackDiscoverySchedule = enableAttackDiscoverySchedule;
/** Disables the attack discovery schedule. */
const disableAttackDiscoverySchedule = async ({
  id,
  signal
}) => {
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID_DISABLE, {
    id
  }), {
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    signal
  });
};
exports.disableAttackDiscoverySchedule = disableAttackDiscoverySchedule;
/** Retrieves attack discovery schedules. */
const findAttackDiscoverySchedule = async ({
  page,
  perPage,
  sortField,
  sortDirection,
  signal
}) => {
  // public API expects snake_case query params
  const query = {
    page,
    per_page: perPage,
    sort_field: sortField,
    sort_direction: sortDirection
  };
  return _kibana.KibanaServices.get().http.get(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_FIND, {
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    query,
    signal
  });
};

/** Retrieves registered rule types. */
exports.findAttackDiscoverySchedule = findAttackDiscoverySchedule;
const fetchRuleTypes = async params => {
  const {
    signal
  } = params !== null && params !== void 0 ? params : {};
  return _kibana.KibanaServices.get().http.get(ALERTING_RULE_TYPES_URL, {
    signal
  });
};
exports.fetchRuleTypes = fetchRuleTypes;