"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttackDiscoveryAttachment = void 0;
var _react = require("react");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _prompts = require("../../../../agent_builder/components/prompts");
var _use_agent_builder_attachment = require("../../../../agent_builder/hooks/use_agent_builder_attachment");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ATTACK_DISCOVERY_ATTACHMENT_LABEL = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.agentBuilder.attachmentLabel', {
  defaultMessage: 'Attack discovery'
});
const useAttackDiscoveryAttachment = (attackDiscovery, replacements) => {
  const alertAttachment = (0, _react.useMemo)(() => {
    var _attackDiscovery$titl;
    return {
      attachmentType: _constants.SecurityAgentBuilderAttachments.alert,
      attachmentData: {
        alert: attackDiscovery ? (0, _elasticAssistantCommon.getAttackDiscoveryMarkdown)({
          attackDiscovery,
          replacements
        }) : '',
        attachmentLabel: (_attackDiscovery$titl = attackDiscovery === null || attackDiscovery === void 0 ? void 0 : attackDiscovery.title) !== null && _attackDiscovery$titl !== void 0 ? _attackDiscovery$titl : DEFAULT_ATTACK_DISCOVERY_ATTACHMENT_LABEL
      },
      attachmentPrompt: _prompts.ATTACK_DISCOVERY_ATTACHMENT_PROMPT
    };
  }, [attackDiscovery, replacements]);
  const {
    openAgentBuilderFlyout
  } = (0, _use_agent_builder_attachment.useAgentBuilderAttachment)(alertAttachment);
  return openAgentBuilderFlyout;
};
exports.useAttackDiscoveryAttachment = useAttackDiscoveryAttachment;