"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToNewCase = void 0;
var _common = require("@kbn/cases-plugin/common");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/take_action/use_add_to_case/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAddToNewCase = ({
  canUserCreateAndReadCases,
  title,
  onClick
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const {
    alertsIndexPattern
  } = (0, _elasticAssistant.useAssistantContext)();
  const createCaseFlyout = cases.hooks.useCasesAddToNewCaseFlyout({
    initialValue: {
      description: i18n.CASE_DESCRIPTION(title),
      title
    },
    toastContent: i18n.ADD_TO_CASE_SUCCESS
  });
  const openCreateCaseFlyout = (0, _react.useCallback)(({
    alertIds,
    headerContent,
    markdownComments,
    replacements
  }) => {
    const userCommentAttachments = markdownComments.map(x => ({
      comment: x,
      type: _common.AttachmentType.user
    }));
    const originalAlertIds = (0, _elasticAssistantCommon.getOriginalAlertIds)({
      alertIds,
      replacements
    });
    const alertAttachments = originalAlertIds.map(alertId => ({
      alertId,
      index: alertsIndexPattern !== null && alertsIndexPattern !== void 0 ? alertsIndexPattern : '',
      rule: {
        id: null,
        name: null
      },
      type: _common.AttachmentType.alert
    }));
    const attachments = [...userCommentAttachments, ...alertAttachments];
    createCaseFlyout.open({
      attachments,
      headerContent
    });
  }, [alertsIndexPattern, createCaseFlyout]);
  const headerContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, i18n.CREATE_A_CASE_FOR_ATTACK_DISCOVERY(title)), [title]);
  const onAddToNewCase = (0, _react.useCallback)(({
    alertIds,
    markdownComments,
    replacements
  }) => {
    if (onClick) {
      onClick();
    }
    openCreateCaseFlyout({
      alertIds,
      headerContent,
      markdownComments,
      replacements
    });
  }, [headerContent, onClick, openCreateCaseFlyout]);
  return {
    disabled: !canUserCreateAndReadCases(),
    onAddToNewCase
  };
};
exports.useAddToNewCase = useAddToNewCase;