"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveryWithOriginalValues = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Swaps anonymized values with original values in an attack discovery.
 * This is used when sending attack discovery data to the agent builder,
 * so that the original values are used instead of anonymized placeholders.
 */
const getAttackDiscoveryWithOriginalValues = ({
  attackDiscovery,
  replacements
}) => {
  if (!replacements) {
    return attackDiscovery;
  }
  return {
    ...attackDiscovery,
    detailsMarkdown: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: attackDiscovery.detailsMarkdown,
      replacements
    }),
    entitySummaryMarkdown: attackDiscovery.entitySummaryMarkdown ? (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: attackDiscovery.entitySummaryMarkdown,
      replacements
    }) : undefined,
    summaryMarkdown: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: attackDiscovery.summaryMarkdown,
      replacements
    }),
    title: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: attackDiscovery.title,
      replacements
    })
  };
};
exports.getAttackDiscoveryWithOriginalValues = getAttackDiscoveryWithOriginalValues;