"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isHostName = exports.getHostFlyoutPanelProps = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostPanelKey = 'host-panel';
const isHostName = fieldName => fieldName === 'host.name' || fieldName === 'host.hostname';
exports.isHostName = isHostName;
const getHostFlyoutPanelProps = ({
  contextId,
  hostName
}) => ({
  id: HostPanelKey,
  params: {
    hostName,
    contextID: contextId,
    scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
  }
});
exports.getHostFlyoutPanelProps = getHostFlyoutPanelProps;