"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoadingMessage = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLoadingMessage = ({
  alertsCount,
  end,
  start
}) => {
  if (start === _elasticAssistantCommon.DEFAULT_START && end === _elasticAssistantCommon.DEFAULT_END) {
    return (0, _translations.AI_IS_CURRENTLY_ANALYZING)(alertsCount);
  }
  if (end != null && start != null) {
    return (0, _translations.AI_IS_CURRENTLY_ANALYZING_RANGE)({
      alertsCount,
      end,
      start
    });
  } else if (start != null) {
    return (0, _translations.AI_IS_CURRENTLY_ANALYZING_FROM)({
      alertsCount,
      from: start
    });
  } else {
    return (0, _translations.AI_IS_CURRENTLY_ANALYZING)(alertsCount);
  }
};
exports.getLoadingMessage = getLoadingMessage;