"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedDate = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormattedDate = ({
  date,
  dateFormat
}) => {
  if (date == null) {
    return null;
  }

  // strictly parse the date, which will fail for dates like formatted like 'now':
  const strictParsed = (0, _moment.default)(date, _moment.default.ISO_8601, true);
  if (!strictParsed.isValid()) {
    return date; // return the original date if it cannot be parsed
  }

  // return the formatted date per the time zone:
  return (0, _moment.default)(date).format(dateFormat);
};
exports.getFormattedDate = getFormattedDate;