"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingCallout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _countdown = require("./countdown");
var _loading_messages = require("./loading_messages");
var i18n = _interopRequireWildcard(require("./translations"));
var _get_is_terminal_state = require("./get_is_terminal_state");
var _use_dismiss_attack_discovery_generations = require("../use_dismiss_attack_discovery_generations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/loading_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BACKGROUND_COLOR_LIGHT = '#E6F1FA';
const BACKGROUND_COLOR_DARK = '#0B2030';
const BORDER_COLOR_DARK = '#0B2030';
const LoadingCalloutComponent = ({
  alertsContextCount,
  approximateFutureTime,
  averageSuccessfulDurationNanoseconds,
  connectorName,
  discoveries,
  end,
  executionUuid,
  generationEndTime,
  localStorageAttackDiscoveryMaxAlerts,
  loadingMessage,
  reason,
  refetchGenerations,
  start,
  status,
  successfulGenerations
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const isTerminalState = (0, _react2.useMemo)(() => (0, _get_is_terminal_state.getIsTerminalState)(status), [status]);
  const leftContent = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "leftContent",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, isTerminalState ? /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingElastic, {
    "data-test-subj": "loadingElastic",
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            margin-left: ${euiTheme.size.m};
          `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_loading_messages.LoadingMessages, {
    alertsContextCount: alertsContextCount,
    connectorName: connectorName,
    discoveries: discoveries,
    end: end,
    generationEndTime: generationEndTime,
    loadingMessage: loadingMessage,
    localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
    reason: reason,
    start: start,
    status: status,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))), [alertsContextCount, connectorName, discoveries, end, euiTheme.size.m, generationEndTime, isTerminalState, loadingMessage, localStorageAttackDiscoveryMaxAlerts, reason, start, status]);
  const backgroundColor = (0, _react2.useMemo)(() => {
    const defaultBackgroundColor = isDarkMode ? BACKGROUND_COLOR_DARK : BACKGROUND_COLOR_LIGHT;
    const successBackgroundColor = euiTheme.colors.backgroundBaseSuccess;
    const failedBackgroundColor = euiTheme.colors.backgroundBaseDanger;
    if (status === 'succeeded') {
      return successBackgroundColor;
    }
    if (status === 'failed') {
      return failedBackgroundColor;
    }
    return defaultBackgroundColor;
  }, [euiTheme.colors.backgroundBaseDanger, euiTheme.colors.backgroundBaseSuccess, isDarkMode, status]);
  const borderColor = (0, _react2.useMemo)(() => {
    const defaultBorderColor = isDarkMode ? BORDER_COLOR_DARK : euiTheme.colors.lightShade;
    const successBorderColor = euiTheme.colors.borderBaseSuccess;
    const failedBorderColor = euiTheme.colors.borderBaseDanger;
    if (status === 'succeeded') {
      return successBorderColor;
    }
    if (status === 'failed') {
      return failedBorderColor;
    }
    return defaultBorderColor;
  }, [euiTheme.colors.borderBaseDanger, euiTheme.colors.borderBaseSuccess, euiTheme.colors.lightShade, isDarkMode, status]);
  const {
    mutateAsync: dismissAttackDiscoveryGeneration
  } = (0, _use_dismiss_attack_discovery_generations.useDismissAttackDiscoveryGeneration)();
  const [isDismissing, setIsDismissing] = (0, _react2.useState)(false);
  const dismissGeneration = (0, _react2.useCallback)(async () => {
    try {
      if (executionUuid != null) {
        setIsDismissing(true);
        await dismissAttackDiscoveryGeneration({
          executionUuid
        });
        refetchGenerations === null || refetchGenerations === void 0 ? void 0 : refetchGenerations(); // force a refresh of the generations list
      }
    } finally {
      setIsDismissing(false);
    }
  }, [dismissAttackDiscoveryGeneration, executionUuid, refetchGenerations]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        background-color: ${backgroundColor};
        border: 1px solid ${borderColor};
        border-radius: 6px;
        padding: ${euiTheme.size.base};
      `,
    "data-test-subj": "loadingCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, leftContent), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, !isTerminalState && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_countdown.Countdown, {
    approximateFutureTime: approximateFutureTime,
    averageSuccessfulDurationNanoseconds: averageSuccessfulDurationNanoseconds,
    successfulGenerations: successfulGenerations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                margin-left: ${euiTheme.size.m};
              `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }, isDismissing ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "loadingSpinner",
    size: "m",
    css: (0, _react.css)`
                    color: ${euiTheme.colors.text};
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.CLOSE,
    disabled: isDismissing,
    iconType: "cross",
    onClick: dismissGeneration,
    "data-test-subj": "dismissButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 17
    }
  }))))));
};
LoadingCalloutComponent.displayName = 'LoadingCallout';
const LoadingCallout = exports.LoadingCallout = /*#__PURE__*/_react2.default.memo(LoadingCalloutComponent);