"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AugmentMessageCodeBlocksPortal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _augment_message_code_block_button = require("./augment_message_code_block_button");
var _kibana = require("../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/assistant/use_augment_message_code_blocks/augment_message_code_blocks_portal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AugmentMessageCodeBlocksPortal = () => {
  const [portals, setPortals] = (0, _react.useState)({});
  const {
    elasticAssistantSharedState
  } = (0, _kibana.useKibana)().services;
  const mountMessageCodeBlocks = ({
    currentConversation,
    showAnonymizedValues
  }) => {
    const codeBlockDetails = currentConversation.messages.map(({
      content
    }) => (0, _elasticAssistant.analyzeMarkdown)(showAnonymizedValues ? content !== null && content !== void 0 ? content : '' : (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: content !== null && content !== void 0 ? content : '',
      replacements: currentConversation.replacements
    })));
    const mountingFunctions = codeBlockDetails.flatMap((codeBlocks, messageIndex) => codeBlocks.map((codeBlock, codeBlockIndex) => {
      const mount = () => {
        const controlContainer = document.querySelectorAll(`.message-${messageIndex} .euiCodeBlock__controls`)[codeBlockIndex];
        if (!controlContainer) {
          return () => {};
        }
        const portalId = `code-block-portal-${currentConversation.id}-${messageIndex}-${codeBlockIndex}`;
        const portalNode = (0, _reactReversePortal.createHtmlPortalNode)();
        const inPortal = /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
          key: portalId,
          node: portalNode,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_augment_message_code_block_button.AugmentMessageCodeBlockButton, {
          currentConversation: currentConversation,
          codeBlockDetails: codeBlock,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 15
          }
        }));
        setPortals(prev => ({
          ...prev,
          [portalId]: {
            portalId,
            node: portalNode,
            target: controlContainer,
            inPortal
          }
        }));
        return () => {
          portalNode.unmount();
          setPortals(prev => {
            const next = {
              ...prev
            };
            delete next[portalId];
            return next;
          });
        };
      };
      return mount;
    }));
    const mountAll = () => {
      const unmounters = mountingFunctions.map(fn => fn());
      return () => unmounters.forEach(unmount => unmount());
    };
    return mountAll();
  };
  (0, _react.useEffect)(() => {
    const cleanup = elasticAssistantSharedState.augmentMessageCodeBlocks.registerAugmentMessageCodeBlocks({
      mount: mountMessageCodeBlocks
    });
    return () => {
      cleanup();
      setPortals({});
    };
  }, [elasticAssistantSharedState.augmentMessageCodeBlocks]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.values(portals).map(({
    portalId,
    inPortal
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: portalId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, inPortal)), Object.values(portals).map(({
    portalId,
    node,
    target
  }) => target ? /*#__PURE__*/_reactDom.default.createPortal(/*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: node,
    key: portalId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 40
    }
  }), target) : null));
};
exports.AugmentMessageCodeBlocksPortal = AugmentMessageCodeBlocksPortal;