"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDynamicEntityFlyout = void 0;
var _expandableFlyout = require("@kbn/expandable-flyout");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../flyout/entity_details/shared/constants");
var _use_on_expandable_flyout_close = require("../../flyout/shared/hooks/use_on_expandable_flyout_close");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDynamicEntityFlyout = ({
  onFlyoutClose
}) => {
  const {
    openFlyout,
    closeFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    notifications
  } = (0, _kibana.useKibana)().services;
  (0, _use_on_expandable_flyout_close.useOnExpandableFlyoutClose)({
    callback: onFlyoutClose
  });
  const openDynamicFlyout = ({
    entityDocId,
    entityType,
    entityName,
    scopeId,
    contextId
  }) => {
    // User, Host, and Service entity flyouts rely on entity name to fetch required data
    if (entityType && ['user', 'host', 'service'].includes(entityType) && !entityName) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.openFlyout.missingEntityNameTitle', {
          defaultMessage: 'Missing Entity Name'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.assetInventory.openFlyout.missingEntityNameText', {
          defaultMessage: 'Entity name is required for User, Host, and Service entities'
        })
      });
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_EXPAND_FLYOUT_ERROR);
      onFlyoutClose();
      return;
    }
    switch (entityType) {
      case 'user':
        openFlyout({
          right: {
            id: _constants.UserPanelKey,
            params: {
              userName: entityName,
              scopeId,
              contextId
            }
          }
        });
        break;
      case 'host':
        openFlyout({
          right: {
            id: _constants.HostPanelKey,
            params: {
              hostName: entityName,
              scopeId,
              contextId
            }
          }
        });
        break;
      case 'service':
        openFlyout({
          right: {
            id: _constants.ServicePanelKey,
            params: {
              serviceName: entityName,
              scopeId,
              contextId
            }
          }
        });
        break;
      default:
        openFlyout({
          right: {
            id: _constants.GenericEntityPanelKey,
            params: {
              entityDocId,
              scopeId,
              contextId,
              isEngineMetadataExist: Boolean(entityType) // Pass whether entityType exists to avoid error state in generic flyout
            }
          }
        });
        break;
    }
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_EXPAND_FLYOUT_SUCCESS);
  };
  const closeDynamicFlyout = () => {
    closeFlyout();
  };
  return {
    openDynamicFlyout,
    closeDynamicFlyout
  };
};
exports.useDynamicEntityFlyout = useDynamicEntityFlyout;