"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERS = exports.TRUSTED_DEVICES = exports.TRUSTED_APPLICATIONS = exports.TIMELINES = exports.SIEM_RULES = exports.SIEM_READINESS = exports.SCRIPTS_LIBRARY = exports.RULES = exports.RESPONSE_ACTIONS_HISTORY = exports.PROTECTION_UPDATES = exports.POLICIES = exports.OVERVIEW = exports.NOTES = exports.NETWORK = exports.MANAGE = exports.KUBERNETES = exports.INVENTORY = exports.HOST_ISOLATION_EXCEPTIONS = exports.HOSTS = exports.GETTING_STARTED = exports.EXPLORE = exports.EXCEPTIONS = exports.EVENT_FILTERS = exports.ENTITY_STORE = exports.ENTITY_ANALYTICS_RISK_SCORE = exports.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING = exports.ENTITY_ANALYTICS = exports.ENDPOINT_EXCEPTIONS = exports.ENDPOINTS = exports.DETECTION_RESPONSE = exports.DATA_QUALITY = exports.DASHBOARDS = exports.CREATE_NEW_RULE = exports.COVERAGE_OVERVIEW = exports.CONFIGURATIONS = exports.CASE = exports.BLOCKLIST = exports.ATTACK_DISCOVERY = exports.ATTACKS = exports.ASSET_CRITICALITY = exports.ALERT_SUMMARY = exports.ALERTS = exports.AI_VALUE_DASHBOARD = exports.ADD_RULES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OVERVIEW = exports.OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.navigation.overview', {
  defaultMessage: 'Overview'
});
const DATA_QUALITY = exports.DATA_QUALITY = _i18n.i18n.translate('xpack.securitySolution.navigation.ecsDataQualityDashboard', {
  defaultMessage: 'Data Quality'
});
const AI_VALUE_DASHBOARD = exports.AI_VALUE_DASHBOARD = _i18n.i18n.translate('xpack.securitySolution.navigation.aiValue', {
  defaultMessage: 'Value report'
});
const ENTITY_ANALYTICS_RISK_SCORE = exports.ENTITY_ANALYTICS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.navigation.entityRiskScore', {
  defaultMessage: 'Entity risk score'
});
const ENTITY_STORE = exports.ENTITY_STORE = _i18n.i18n.translate('xpack.securitySolution.navigation.entityStore', {
  defaultMessage: 'Entity store'
});
const NOTES = exports.NOTES = _i18n.i18n.translate('xpack.securitySolution.navigation.notes', {
  defaultMessage: 'Notes'
});
const ASSET_CRITICALITY = exports.ASSET_CRITICALITY = _i18n.i18n.translate('xpack.securitySolution.navigation.assetCriticality', {
  defaultMessage: 'Asset criticality'
});
const DETECTION_RESPONSE = exports.DETECTION_RESPONSE = _i18n.i18n.translate('xpack.securitySolution.navigation.detectionResponse', {
  defaultMessage: 'Detection & Response'
});
const ENTITY_ANALYTICS = exports.ENTITY_ANALYTICS = _i18n.i18n.translate('xpack.securitySolution.navigation.entityAnalytics', {
  defaultMessage: 'Entity analytics'
});
const ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING = exports.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING = _i18n.i18n.translate('xpack.securitySolution.navigation.privilegedUserMonitoring', {
  defaultMessage: 'Privileged user monitoring'
});
const HOSTS = exports.HOSTS = _i18n.i18n.translate('xpack.securitySolution.navigation.hosts', {
  defaultMessage: 'Hosts'
});
const GETTING_STARTED = exports.GETTING_STARTED = _i18n.i18n.translate('xpack.securitySolution.navigation.gettingStarted', {
  defaultMessage: 'Get started'
});
const DASHBOARDS = exports.DASHBOARDS = _i18n.i18n.translate('xpack.securitySolution.navigation.dashboards', {
  defaultMessage: 'Dashboards'
});
const COVERAGE_OVERVIEW = exports.COVERAGE_OVERVIEW = _i18n.i18n.translate('xpack.securitySolution.navigation.coverageOverviewDashboard', {
  defaultMessage: 'MITRE ATT&CK\u00AE Coverage'
});
const NETWORK = exports.NETWORK = _i18n.i18n.translate('xpack.securitySolution.navigation.network', {
  defaultMessage: 'Network'
});
const USERS = exports.USERS = _i18n.i18n.translate('xpack.securitySolution.navigation.users', {
  defaultMessage: 'Users'
});
const KUBERNETES = exports.KUBERNETES = _i18n.i18n.translate('xpack.securitySolution.navigation.kubernetes', {
  defaultMessage: 'Kubernetes'
});
const RULES = exports.RULES = _i18n.i18n.translate('xpack.securitySolution.navigation.rules', {
  defaultMessage: 'Rules'
});
const SIEM_RULES = exports.SIEM_RULES = _i18n.i18n.translate('xpack.securitySolution.navigation.detectionRules', {
  defaultMessage: 'Detection rules (SIEM)'
});
const ADD_RULES = exports.ADD_RULES = _i18n.i18n.translate('xpack.securitySolution.navigation.addRules', {
  defaultMessage: 'Add Rules'
});
const EXCEPTIONS = exports.EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.navigation.exceptions', {
  defaultMessage: 'Shared exception lists'
});
const ALERTS = exports.ALERTS = _i18n.i18n.translate('xpack.securitySolution.navigation.alerts', {
  defaultMessage: 'Alerts'
});
const ATTACKS = exports.ATTACKS = _i18n.i18n.translate('xpack.securitySolution.navigation.attacks', {
  defaultMessage: 'Attacks'
});
const ALERT_SUMMARY = exports.ALERT_SUMMARY = _i18n.i18n.translate('xpack.securitySolution.navigation.alertSummary', {
  defaultMessage: 'Alert summary'
});
const ATTACK_DISCOVERY = exports.ATTACK_DISCOVERY = _i18n.i18n.translate('xpack.securitySolution.navigation.attackDiscovery', {
  defaultMessage: 'Attack discovery'
});
const INVENTORY = exports.INVENTORY = _i18n.i18n.translate('xpack.securitySolution.navigation.inventory', {
  defaultMessage: 'Inventory'
});
const SIEM_READINESS = exports.SIEM_READINESS = _i18n.i18n.translate('xpack.securitySolution.navigation.siemReadiness', {
  defaultMessage: 'SIEM Readiness'
});
const TIMELINES = exports.TIMELINES = _i18n.i18n.translate('xpack.securitySolution.navigation.timelines', {
  defaultMessage: 'Timelines'
});
const CASE = exports.CASE = _i18n.i18n.translate('xpack.securitySolution.navigation.case', {
  defaultMessage: 'Cases'
});
const CONFIGURATIONS = exports.CONFIGURATIONS = _i18n.i18n.translate('xpack.securitySolution.navigation.configurations', {
  defaultMessage: 'Configurations'
});
const ENDPOINTS = exports.ENDPOINTS = _i18n.i18n.translate('xpack.securitySolution.search.administration.endpoints', {
  defaultMessage: 'Endpoints'
});
const POLICIES = exports.POLICIES = _i18n.i18n.translate('xpack.securitySolution.navigation.administration.policies', {
  defaultMessage: 'Policies'
});
const ENDPOINT_EXCEPTIONS = exports.ENDPOINT_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.search.administration.endpointExceptions', {
  defaultMessage: 'Endpoint exceptions'
});
const TRUSTED_APPLICATIONS = exports.TRUSTED_APPLICATIONS = _i18n.i18n.translate('xpack.securitySolution.search.administration.trustedApps', {
  defaultMessage: 'Trusted applications'
});
const TRUSTED_DEVICES = exports.TRUSTED_DEVICES = _i18n.i18n.translate('xpack.securitySolution.search.administration.trustedDevices', {
  defaultMessage: 'Trusted devices'
});
const EVENT_FILTERS = exports.EVENT_FILTERS = _i18n.i18n.translate('xpack.securitySolution.search.administration.eventFilters', {
  defaultMessage: 'Event filters'
});
const HOST_ISOLATION_EXCEPTIONS = exports.HOST_ISOLATION_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.search.administration.hostIsolationExceptions', {
  defaultMessage: 'Host isolation exceptions'
});
const EXPLORE = exports.EXPLORE = _i18n.i18n.translate('xpack.securitySolution.navigation.explore', {
  defaultMessage: 'Explore'
});
const MANAGE = exports.MANAGE = _i18n.i18n.translate('xpack.securitySolution.navigation.manage', {
  defaultMessage: 'Manage'
});
const BLOCKLIST = exports.BLOCKLIST = _i18n.i18n.translate('xpack.securitySolution.navigation.blocklist', {
  defaultMessage: 'Blocklist'
});
const RESPONSE_ACTIONS_HISTORY = exports.RESPONSE_ACTIONS_HISTORY = _i18n.i18n.translate('xpack.securitySolution.navigation.responseActionsHistory', {
  defaultMessage: 'Response actions history'
});
const SCRIPTS_LIBRARY = exports.SCRIPTS_LIBRARY = _i18n.i18n.translate('xpack.securitySolution.navigation.scriptsLibrary', {
  defaultMessage: 'Scripts library'
});
const PROTECTION_UPDATES = exports.PROTECTION_UPDATES = _i18n.i18n.translate('xpack.securitySolution.navigation.protectionUpdates', {
  defaultMessage: 'Protection updates'
});
const CREATE_NEW_RULE = exports.CREATE_NEW_RULE = _i18n.i18n.translate('xpack.securitySolution.navigation.newRuleTitle', {
  defaultMessage: 'Create new rule'
});