"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReportAddToChat = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * returns a function that reports agent builder add to chat event
 */
const useReportAddToChat = () => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const reportAddToChatClick = (0, _react.useCallback)(payload => {
    telemetry === null || telemetry === void 0 ? void 0 : telemetry.reportEvent(_onechatCommon.AGENT_BUILDER_EVENT_TYPES.AddToChatClicked, payload);
  }, [telemetry]);
  return reportAddToChatClick;
};
exports.useReportAddToChat = useReportAddToChat;