"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentBuilderAvailability = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _public2 = require("@kbn/onechat-plugin/public");
var _kibana = require("../../common/lib/kibana");
var _use_license = require("../../common/hooks/use_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentBuilderAvailability = () => {
  const [chatExperience] = (0, _public.useUiSetting$)(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE, _aiAssistantCommon.AIChatExperience.Classic);
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _kibana.useKibana)();
  const licenseService = (0, _use_license.useLicense)();
  return (0, _react.useMemo)(() => {
    const agentBuilderCapabilities = capabilities[_public2.ONECHAT_FEATURE_ID];
    const hasAgentBuilderPrivilege = (agentBuilderCapabilities === null || agentBuilderCapabilities === void 0 ? void 0 : agentBuilderCapabilities.show) === true;
    const isAgentChatExperienceEnabled = chatExperience === _aiAssistantCommon.AIChatExperience.Agent;
    return {
      isAgentBuilderEnabled: hasAgentBuilderPrivilege && isAgentChatExperienceEnabled,
      hasAgentBuilderPrivilege,
      isAgentChatExperienceEnabled,
      hasValidAgentBuilderLicense: licenseService.isEnterprise()
    };
  }, [capabilities, chatExperience, licenseService]);
};
exports.useAgentBuilderAvailability = useAgentBuilderAvailability;