"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentBuilderAttachment = void 0;
var _react = require("react");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../common/lib/kibana/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to handle agent builder attachment functionality.
 * Opens a conversation flyout with attachments and prefilled conversation.
 */
const useAgentBuilderAttachment = ({
  attachmentType,
  attachmentData,
  attachmentPrompt
}) => {
  const {
    onechat
  } = (0, _use_kibana.useKibana)().services;
  const openAgentBuilderFlyout = (0, _react.useCallback)(() => {
    if (!(onechat !== null && onechat !== void 0 && onechat.openConversationFlyout)) {
      return;
    }

    // Create a unique ID for the attachment
    const attachmentId = `${attachmentType}-${Date.now()}`;

    // Create the UiAttachment object
    const attachment = {
      id: attachmentId,
      type: attachmentType,
      data: attachmentData
    };

    // Open the conversation flyout with attachment and prefilled message
    onechat.openConversationFlyout({
      autoSendInitialMessage: false,
      newConversation: true,
      initialMessage: attachmentPrompt,
      attachments: [attachment],
      sessionTag: 'security',
      agentId: _constants.THREAT_HUNTING_AGENT_ID
    });
  }, [attachmentType, attachmentData, attachmentPrompt, onechat]);
  return {
    openAgentBuilderFlyout
  };
};
exports.useAgentBuilderAttachment = useAgentBuilderAttachment;