"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringifyEssentialAlertData = void 0;
var _lodash = require("lodash");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Filters raw alert data to only include essential fields and stringifies the result.
 * This reduces context window usage by keeping only the most relevant information.
 */
const stringifyEssentialAlertData = rawData => {
  return JSON.stringify((0, _lodash.pick)(rawData, _common.ESSENTIAL_ALERT_FIELDS));
};
exports.stringifyEssentialAlertData = stringifyEssentialAlertData;