"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewAgentBuilderAttachment = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/onechat-plugin/public");
var _use_report_add_to_chat = require("../hooks/use_report_add_to_chat");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_agent_builder_availability = require("../hooks/use_agent_builder_availability");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/agent_builder/components/new_agent_builder_attachment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * `NewAgentBuilderAttachment` displays a button that opens the agent builder flyout
 * with attachment data. You may optionally override the default text.
 */
const NewAgentBuilderAttachment = exports.NewAgentBuilderAttachment = /*#__PURE__*/(0, _react.memo)(function NewAgentBuilderAttachment({
  color = 'primary',
  onClick,
  size = 'm',
  disabled = false,
  telemetry: telemetryData
}) {
  const {
    hasAgentBuilderPrivilege,
    isAgentChatExperienceEnabled,
    hasValidAgentBuilderLicense
  } = (0, _use_agent_builder_availability.useAgentBuilderAvailability)();
  const reportAddToChatClick = (0, _use_report_add_to_chat.useReportAddToChat)();
  const handleClick = (0, _react.useCallback)(() => {
    if (telemetryData) {
      reportAddToChatClick({
        pathway: telemetryData.pathway,
        attachments: telemetryData.attachments
      });
    }
    onClick();
  }, [onClick, reportAddToChatClick, telemetryData]);
  const isDisabled = disabled || !hasValidAgentBuilderLicense;
  const shouldShowLicenseTooltip = !hasValidAgentBuilderLicense;
  if (!hasAgentBuilderPrivilege || !isAgentChatExperienceEnabled) {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": i18n.ADD_TO_CHAT,
    color: color,
    "data-test-subj": "newAgentBuilderAttachment",
    onClick: handleClick,
    size: size,
    disabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _public.onechatIconType,
    color: color === 'primary' ? 'default' : color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, i18n.ADD_TO_CHAT)));
  if (!shouldShowLicenseTooltip) {
    return button;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.UPGRADE_TO_ENTERPRISE_TO_USE_AGENT_BUILDER_CHAT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, button));
});