"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapNullable = exports.map = exports.isDefined = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isDefined = value => {
  return value !== null && value !== undefined;
};
exports.isDefined = isDefined;
const mapNullable = (value, fn) => {
  if (value === null || value === undefined) {
    return undefined;
  }
  return fn(value);
};
exports.mapNullable = mapNullable;
const map = exports.map = mapNullable;