"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.qradarResourceIdentifier = void 0;
var _rules_xml = require("../../parsers/qradar/rules_xml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Identifies QRadar reference sets from rule data XML.
 * Reference sets are QRadar's equivalent of lookups data.
 * They contain data like IPs, strings, etc. that rules reference for checks.
 *
 * @param ruleData - The decoded XML rule data string
 * @returns Array of identified resources with type 'lookup' and reference set names
 */
const qradarResourceIdentifier = async ruleData => {
  const qRadarXmlParser = new _rules_xml.QradarRulesXmlParser();
  let referenceSets = [];
  try {
    referenceSets = await qRadarXmlParser.getReferenceSetsFromRuleData(ruleData);
  } catch (error) {
    const message = `Error parsing QRadar rule data for reference sets: ${error instanceof Error ? error.message : String(error)}`;
    throw new Error(message);
  }
  return referenceSets.map(name => ({
    type: 'lookup',
    name
  }));
};
exports.qradarResourceIdentifier = qradarResourceIdentifier;