"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardResourceIdentifier = void 0;
var _resources = require("../../resources");
var _dashboard_xml = require("../../parsers/splunk/dashboard_xml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardResourceIdentifier extends _resources.ResourceIdentifier {
  async fromOriginal(item) {
    const originalDashboardXMLString = item === null || item === void 0 ? void 0 : item.data;
    if (!originalDashboardXMLString) {
      return [];
    }
    const splunkDashboardXMLPaser = new _dashboard_xml.SplunkXmlDashboardParser(originalDashboardXMLString);
    const queries = await splunkDashboardXMLPaser.extractQueries();
    const resources = await Promise.all(queries.map(query => this.identifier(query)));
    return resources.flat();
  }
}
exports.DashboardResourceIdentifier = DashboardResourceIdentifier;