"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseLocationState = exports.AIValueReportLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _zod = require("@kbn/zod");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _rison = require("@kbn/rison");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeRangeSchema = _zod.z.union([_zod.z.object({
  kind: _zod.z.literal('absolute'),
  from: _zod.z.string().nonempty(),
  to: _zod.z.string().nonempty()
}), _zod.z.object({
  kind: _zod.z.literal('relative'),
  fromStr: _zod.z.string().nonempty(),
  toStr: _zod.z.string().nonempty()
})]);
const AIValueReportParamsSchema = _zod.z.object({
  timeRange: TimeRangeSchema,
  // These are only required when rendering in export mode (e.g. for PDF generation).
  // When a user clicks "Open ..." from Reporting, we intentionally omit these to avoid
  // forcing the destination page into export mode UI.
  insight: _zod.z.string().nonempty().optional(),
  reportDataHash: _zod.z.string().nonempty().optional()
});
class AIValueReportLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _deeplinksAnalytics.AI_VALUE_REPORT_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      // The Security Solution app initializes its date pickers from the `timerange` URL param.
      // Encoding this into the URL ensures "Open ..." from Reporting preselects the time range.
      const timerangeParam = (0, _rison.encode)({
        valueReport: {
          timerange: params.timeRange.kind === 'absolute' ? {
            kind: 'absolute',
            from: params.timeRange.from,
            to: params.timeRange.to
          } : {
            kind: 'relative',
            fromStr: params.timeRange.fromStr,
            toStr: params.timeRange.toStr
          },
          linkTo: []
        }
      });
      return {
        app: _constants.APP_UI_ID,
        path: `${_constants.AI_VALUE_PATH}?timerange=${timerangeParam}`,
        state: params
      };
    });
  }
}
exports.AIValueReportLocatorDefinition = AIValueReportLocatorDefinition;
const parseLocationState = state => {
  const result = AIValueReportParamsSchema.passthrough().safeParse(state);
  if (result.error) {
    // This will cause the page to fallback to rendering normally
    return undefined;
  }
  return result.data;
};
exports.parseLocationState = parseLocationState;