"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isScriptsLibraryKqlFilterValid = exports.KUERY_FIELD_TO_SO_FIELD_MAP = void 0;
var esKuery = _interopRequireWildcard(require("@kbn/es-query"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * List of fields that can be used in KQL and their associated mapping in the SO type
 */
const KUERY_FIELD_TO_SO_FIELD_MAP = exports.KUERY_FIELD_TO_SO_FIELD_MAP = Object.freeze({
  id: 'id',
  name: 'name',
  platform: 'platform',
  requiresInput: 'requires_input',
  description: 'description',
  instructions: 'instructions',
  example: 'example',
  pathToExecutable: 'path_to_executable',
  createdBy: 'created_by',
  createdAt: 'created_at',
  updatedBy: 'updated_by',
  updatedAt: 'updated_at'
});
const isScriptsLibraryKqlFilterValid = kuery => {
  const response = {
    isValid: true,
    error: undefined
  };
  if (!kuery.trim()) {
    return response;
  }
  const allowedFields = Object.keys(KUERY_FIELD_TO_SO_FIELD_MAP);
  const fields = esKuery.getKqlFieldNamesFromExpression(kuery);
  for (const field of fields) {
    if (!allowedFields.includes(field)) {
      response.isValid = false;
      response.error = `Invalid KQL filter field: ${field}`;
      return response;
    }
  }
  return response;
};
exports.isScriptsLibraryKqlFilterValid = isScriptsLibraryKqlFilterValid;