"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetTimelinesResponse = exports.GetTimelinesRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _components = require("../model/components.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Elastic Security - Timeline - Get Timelines API
 *   version: 2023-10-31
 */

const GetTimelinesRequestQuery = exports.GetTimelinesRequestQuery = _zod.z.object({
  /**
   * If true, only timelines that are marked as favorites by the user are returned.
   */
  only_user_favorite: _zod.z.enum(['true', 'false']).nullable().optional(),
  timeline_type: _components.TimelineType.nullable().optional(),
  sort_field: _components.SortFieldTimeline.optional(),
  /**
   * Whether to sort the results `ascending` or `descending`
   */
  sort_order: _zod.z.enum(['asc', 'desc']).optional(),
  /**
   * How many results should returned at once
   */
  page_size: _zod.z.string().nullable().optional(),
  /**
   * How many pages should be skipped
   */
  page_index: _zod.z.string().nullable().optional(),
  /**
   * Allows to search for timelines by their title
   */
  search: _zod.z.string().nullable().optional(),
  status: _components.TimelineStatus.nullable().optional()
});
const GetTimelinesResponse = exports.GetTimelinesResponse = _zod.z.object({
  timeline: _zod.z.array(_components.TimelineResponse),
  /**
   * The total amount of results
   */
  totalCount: _zod.z.number(),
  /**
   * The amount of `default` type Timelines in the results
   */
  defaultTimelineCount: _zod.z.number().optional(),
  /**
   * The amount of Timeline templates in the results
   */
  templateTimelineCount: _zod.z.number().optional(),
  /**
   * The amount of favorited Timelines
   */
  favoriteCount: _zod.z.number().optional(),
  /**
   * The amount of Elastic's Timeline templates in the results
   */
  elasticTemplateTimelineCount: _zod.z.number().optional(),
  /**
   * The amount of custom Timeline templates in the results
   */
  customTemplateTimelineCount: _zod.z.number().optional()
});