"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertTags = exports.AlertTag = exports.AlertStatusExceptClosedEnum = exports.AlertStatusExceptClosed = exports.AlertStatusEnum = exports.AlertStatus = exports.AlertIds = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Shared Alert Primitives Schema
 *   version: not applicable
 */

/**
 * A list of alerts `id`s.
 */

const AlertIds = exports.AlertIds = _zod.z.array(_zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString)).min(1);

/**
 * Use alert tags to organize related alerts into categories that you can filter and group.
 */

const AlertTag = exports.AlertTag = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * List of keywords to organize related alerts into categories that you can filter and group.
 */

const AlertTags = exports.AlertTags = _zod.z.array(AlertTag);

/**
 * The status of an alert, which can be `open`, `acknowledged`, `in-progress`, or `closed`.
 */

const AlertStatus = exports.AlertStatus = _zod.z.enum(['open', 'closed', 'acknowledged', 'in-progress']);
const AlertStatusEnum = exports.AlertStatusEnum = AlertStatus.enum;

/**
 * The status of an alert, which can be `open`, `acknowledged`, `in-progress`, or `closed`.
 */

const AlertStatusExceptClosed = exports.AlertStatusExceptClosed = _zod.z.enum(['open', 'acknowledged', 'in-progress']);
const AlertStatusExceptClosedEnum = exports.AlertStatusExceptClosedEnum = AlertStatusExceptClosed.enum;