"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateableMonitoringEntitySourceProperties = exports.UpdateEntitySourceResponse = exports.UpdateEntitySourceRequestParams = exports.UpdateEntitySourceRequestBody = exports.UpdateEntitySourceNoadditionalProps = exports.MonitoringEntitySourceTypeEnum = exports.MonitoringEntitySourceType = exports.MonitoringEntitySourceProperties = exports.MonitoringEntitySourceAttributes = exports.MonitoringEntitySource = exports.Matcher = exports.ListEntitySourcesResponse = exports.ListEntitySourcesRequestQuery = exports.Integrations = exports.GetEntitySourceResponse = exports.GetEntitySourceRequestParams = exports.Filter = exports.DeleteEntitySourceRequestParams = exports.CreateEntitySourceResponse = exports.CreateEntitySourceRequestBody = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Monitoring Entity Source Schema
 *   version: 2023-10-31
 */

const MonitoringEntitySourceType = exports.MonitoringEntitySourceType = _zod.z.enum(['index', 'entity_analytics_integration']);
const MonitoringEntitySourceTypeEnum = exports.MonitoringEntitySourceTypeEnum = MonitoringEntitySourceType.enum;
const Matcher = exports.Matcher = _zod.z.object({
  fields: _zod.z.array(_zod.z.string()),
  /** 
      * Matcher values. Must be either an array of strings (e.g. group or role names) or an array of booleans (e.g. integration-derived flags like privileged_group_member). Mixed types are intentionally not supported for simplicity and predictability.
        */
  values: _zod.z.union([_zod.z.array(_zod.z.string()), _zod.z.array(_zod.z.boolean())])
});
const Filter = exports.Filter = _zod.z.object({
  kuery: _zod.z.union([_zod.z.string(), _zod.z.object({})]).optional()
});
const Integrations = exports.Integrations = _zod.z.object({
  /**
   * Index to read latest sync markers from
   */
  syncMarkerIndex: _zod.z.string().optional(),
  /**
   * integrations latest full sync and update syncData
   */
  syncData: _zod.z.object({
    /**
     * Timestamp of the last full sync from integrations
     */
    lastFullSync: _zod.z.string().datetime().optional(),
    /**
     * Timestamp of the last update processed from integrations
     */
    lastUpdateProcessed: _zod.z.string().datetime().optional()
  }).optional()
});
const UpdateableMonitoringEntitySourceProperties = exports.UpdateableMonitoringEntitySourceProperties = _zod.z.object({
  name: _zod.z.string().optional(),
  indexPattern: _zod.z.string().optional(),
  integrationName: _zod.z.string().optional(),
  enabled: _zod.z.boolean().optional(),
  matchers: _zod.z.array(Matcher).optional(),
  filter: Filter.optional(),
  integrations: Integrations.optional()
});
const UpdateEntitySourceNoadditionalProps = exports.UpdateEntitySourceNoadditionalProps = UpdateableMonitoringEntitySourceProperties.merge(_zod.z.object({}).strict());
const MonitoringEntitySourceProperties = exports.MonitoringEntitySourceProperties = UpdateableMonitoringEntitySourceProperties.merge(_zod.z.object({
  type: MonitoringEntitySourceType.optional(),
  managed: _zod.z.boolean().optional()
}));
const MonitoringEntitySourceAttributes = exports.MonitoringEntitySourceAttributes = MonitoringEntitySourceProperties.merge(_zod.z.object({}));
const MonitoringEntitySource = exports.MonitoringEntitySource = MonitoringEntitySourceProperties.merge(_zod.z.object({
  id: _zod.z.string()
}));
const CreateEntitySourceRequestBody = exports.CreateEntitySourceRequestBody = _zod.z.object({
  type: MonitoringEntitySourceType,
  name: _zod.z.string(),
  indexPattern: _zod.z.string().optional(),
  enabled: _zod.z.boolean().optional(),
  matchers: _zod.z.array(Matcher).optional(),
  filter: Filter.optional()
}).strict();
const CreateEntitySourceResponse = exports.CreateEntitySourceResponse = MonitoringEntitySource;
const DeleteEntitySourceRequestParams = exports.DeleteEntitySourceRequestParams = _zod.z.object({
  id: _zod.z.string()
});
const GetEntitySourceRequestParams = exports.GetEntitySourceRequestParams = _zod.z.object({
  id: _zod.z.string()
});
const GetEntitySourceResponse = exports.GetEntitySourceResponse = MonitoringEntitySource;
const ListEntitySourcesRequestQuery = exports.ListEntitySourcesRequestQuery = _zod.z.object({
  type: _zod.z.string().optional(),
  managed: _zodHelpers.BooleanFromString.optional(),
  name: _zod.z.string().optional(),
  page: _zod.z.coerce.number().int().min(1).optional(),
  per_page: _zod.z.coerce.number().int().min(1).max(10000).optional(),
  sort_field: _zod.z.string().optional(),
  sort_order: _zod.z.enum(['asc', 'desc']).optional()
});
const ListEntitySourcesResponse = exports.ListEntitySourcesResponse = _zod.z.object({
  sources: _zod.z.array(MonitoringEntitySource),
  page: _zod.z.number().int().min(1),
  per_page: _zod.z.number().int().min(1).max(10000),
  total: _zod.z.number().int().min(0)
});
const UpdateEntitySourceRequestParams = exports.UpdateEntitySourceRequestParams = _zod.z.object({
  id: _zod.z.string()
});
const UpdateEntitySourceRequestBody = exports.UpdateEntitySourceRequestBody = UpdateEntitySourceNoadditionalProps;
const UpdateEntitySourceResponse = exports.UpdateEntitySourceResponse = MonitoringEntitySource;