"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateWorkflowInsightRequestSchema = exports.GetWorkflowInsightsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const arrayWithNonEmptyString = field => _configSchema.schema.arrayOf(_configSchema.schema.string({
  minLength: 1,
  validate: id => {
    if (id.trim() === '') {
      return `${field} cannot be an empty string`;
    }
  }
}));
const UpdateWorkflowInsightRequestSchema = exports.UpdateWorkflowInsightRequestSchema = {
  params: _configSchema.schema.object({
    insightId: _configSchema.schema.string({
      minLength: 1,
      validate: id => {
        if (id.trim() === '') {
          return 'insightId cannot be an empty string';
        }
      }
    })
  }),
  body: _configSchema.schema.object({
    '@timestamp': _configSchema.schema.maybe(_configSchema.schema.string()),
    message: _configSchema.schema.maybe(_configSchema.schema.string()),
    category: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('endpoint')])),
    type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('incompatible_antivirus'), _configSchema.schema.literal('policy_response_failure'), _configSchema.schema.literal('noisy_process_tree')])),
    source: _configSchema.schema.maybe(_configSchema.schema.object({
      type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('llm-connector')])),
      id: _configSchema.schema.maybe(_configSchema.schema.string()),
      data_range_start: _configSchema.schema.maybe(_configSchema.schema.string()),
      data_range_end: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    target: _configSchema.schema.maybe(_configSchema.schema.object({
      type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('endpoint')])),
      ids: _configSchema.schema.maybe(arrayWithNonEmptyString('target.id'))
    })),
    action: _configSchema.schema.maybe(_configSchema.schema.object({
      type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('refreshed'), _configSchema.schema.literal('remediated'), _configSchema.schema.literal('suppressed'), _configSchema.schema.literal('dismissed')])),
      timestamp: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    value: _configSchema.schema.maybe(_configSchema.schema.string()),
    remediation: _configSchema.schema.maybe(_configSchema.schema.object({
      exception_list_items: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
        list_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        name: _configSchema.schema.maybe(_configSchema.schema.string()),
        description: _configSchema.schema.maybe(_configSchema.schema.string()),
        entries: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
        tags: _configSchema.schema.maybe(arrayWithNonEmptyString('tag')),
        os_types: _configSchema.schema.maybe(arrayWithNonEmptyString('os_type'))
      }))),
      descriptive: _configSchema.schema.maybe(_configSchema.schema.string()),
      link: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    metadata: _configSchema.schema.maybe(_configSchema.schema.object({
      notes: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
      message_variables: _configSchema.schema.maybe(arrayWithNonEmptyString('message_variable'))
    }))
  })
};
const GetWorkflowInsightsRequestSchema = exports.GetWorkflowInsightsRequestSchema = {
  query: _configSchema.schema.object({
    size: _configSchema.schema.maybe(_configSchema.schema.number()),
    from: _configSchema.schema.maybe(_configSchema.schema.number()),
    ids: _configSchema.schema.maybe(arrayWithNonEmptyString('ids')),
    categories: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('endpoint')]))),
    types: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('incompatible_antivirus'), _configSchema.schema.literal('policy_response_failure'), _configSchema.schema.literal('noisy_process_tree')]))),
    sourceTypes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('llm-connector')]))),
    sourceIds: _configSchema.schema.maybe(arrayWithNonEmptyString('sourceId')),
    targetTypes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('endpoint')]))),
    targetIds: _configSchema.schema.maybe(arrayWithNonEmptyString('targetId')),
    actionTypes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('refreshed'), _configSchema.schema.literal('remediated'), _configSchema.schema.literal('suppressed'), _configSchema.schema.literal('dismissed')])))
  })
};