"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptRequiresInputSchema = exports.ScriptPlatformSchema = exports.ScriptPathToExecutableSchema = exports.ScriptNameSchema = exports.ScriptInstructionsSchema = exports.ScriptFileSchema = exports.ScriptExampleSchema = exports.ScriptDescriptionSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schema_utils = require("../schema_utils");
var _constants = require("../../../endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScriptNameSchema = exports.ScriptNameSchema = _configSchema.schema.string({
  minLength: 1,
  validate: _schema_utils.validateNonEmptyString
});
const ScriptFileSchema = exports.ScriptFileSchema = _configSchema.schema.stream();
const ScriptRequiresInputSchema = exports.ScriptRequiresInputSchema = _configSchema.schema.boolean({
  defaultValue: false
});
const ScriptDescriptionSchema = exports.ScriptDescriptionSchema = _configSchema.schema.string({
  minLength: 1,
  validate: _schema_utils.validateNonEmptyString
});
const ScriptInstructionsSchema = exports.ScriptInstructionsSchema = _configSchema.schema.string({
  minLength: 1,
  validate: _schema_utils.validateNonEmptyString
});
const ScriptExampleSchema = exports.ScriptExampleSchema = _configSchema.schema.string({
  minLength: 1,
  validate: _schema_utils.validateNonEmptyString
});
const ScriptPlatformSchema = exports.ScriptPlatformSchema = _configSchema.schema.arrayOf(
// @ts-expect-error TS2769: No overload matches this call. (due to now `oneOf()` type is defined)
_configSchema.schema.oneOf(_constants.SUPPORTED_HOST_OS_TYPE.map(osType => _configSchema.schema.literal(osType))), {
  minSize: 1,
  maxSize: 3,
  validate: _schema_utils.validateNoDuplicateValues
});
const ScriptPathToExecutableSchema = exports.ScriptPathToExecutableSchema = _configSchema.schema.string({
  minLength: 1,
  validate: _schema_utils.validateNonEmptyString
});