"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetAlertsStatusResponse = exports.SetAlertsStatusRequestBody = exports.SetAlertsStatusByQueryBase = exports.SetAlertsStatusByQuery = exports.SetAlertsStatusByIdsBase = exports.SetAlertsStatusByIds = exports.ReasonEnumEnum = exports.ReasonEnum = exports.CloseAlertsByQuery = exports.CloseAlertsByIds = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _alert = require("../../../model/alert.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Set alerts status API endpoint
 *   version: 2023-10-31
 */

/**
 * The reason for closing the alerts
 */

const ReasonEnum = exports.ReasonEnum = _zod.z.enum(['false_positive', 'duplicate', 'true_positive', 'benign_positive', 'automated_closure', 'other']);
const ReasonEnumEnum = exports.ReasonEnumEnum = ReasonEnum.enum;
const SetAlertsStatusByIdsBase = exports.SetAlertsStatusByIdsBase = _zod.z.object({
  /**
   * List of alert ids. Use field `_id` on alert document or `kibana.alert.uuid`. Note: signals are a deprecated term for alerts.
   */
  signal_ids: _zod.z.array(_zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString)).min(1),
  status: _alert.AlertStatusExceptClosed
});
const CloseAlertsByIds = exports.CloseAlertsByIds = _zod.z.object({
  /**
   * List of alert ids. Use field `_id` on alert document or `kibana.alert.uuid`. Note: signals are a deprecated term for alerts.
   */
  signal_ids: _zod.z.array(_zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString)).min(1),
  status: _zod.z.literal('closed'),
  reason: ReasonEnum.optional()
});
const SetAlertsStatusByIds = exports.SetAlertsStatusByIds = _zod.z.discriminatedUnion('status', [CloseAlertsByIds, SetAlertsStatusByIdsBase]);
const SetAlertsStatusByQueryBase = exports.SetAlertsStatusByQueryBase = _zod.z.object({
  query: _zod.z.object({}).catchall(_zod.z.unknown()),
  status: _alert.AlertStatusExceptClosed,
  conflicts: _zod.z.enum(['abort', 'proceed']).optional().default('abort')
});
const CloseAlertsByQuery = exports.CloseAlertsByQuery = _zod.z.object({
  query: _zod.z.object({}).catchall(_zod.z.unknown()),
  status: _zod.z.literal('closed'),
  conflicts: _zod.z.enum(['abort', 'proceed']).optional().default('abort'),
  reason: ReasonEnum.optional()
});
const SetAlertsStatusByQuery = exports.SetAlertsStatusByQuery = _zod.z.discriminatedUnion('status', [CloseAlertsByQuery, SetAlertsStatusByQueryBase]);
const SetAlertsStatusRequestBody = exports.SetAlertsStatusRequestBody = _zod.z.union([SetAlertsStatusByIds, SetAlertsStatusByQuery]);

/**
 * Elasticsearch update by query response
 */

const SetAlertsStatusResponse = exports.SetAlertsStatusResponse = _zod.z.object({}).catchall(_zod.z.unknown());