"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateFindRulesRequestQuery = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Additional validation that is implemented outside of the schema itself.
 */
const validateFindRulesRequestQuery = query => {
  if (query.sort_order != null || query.sort_field != null) {
    if (query.sort_order == null || query.sort_field == null) {
      return ['when "sort_order" and "sort_field" must exist together or not at all'];
    }
  }
  const ruleExecutionGapQueryParamsSet = new Set([Array.isArray(query.gap_fill_statuses) && query.gap_fill_statuses.length > 0, Boolean(query.gaps_range_start), Boolean(query.gaps_range_end)]);

  // All rule execution gap query params should be specified or omitted (set.size == 1)
  // return an error otherwise
  if (ruleExecutionGapQueryParamsSet.size > 1) {
    return ['Query fields "gap_fill_statuses", "gaps_range_start" and "gaps_range_end" has to be specified together'];
  }
  return [];
};
exports.validateFindRulesRequestQuery = validateFindRulesRequestQuery;