"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatQuery = exports.ThreatMappingEntry = exports.ThreatMapping = exports.ThreatIndicatorPath = exports.ThreatIndex = exports.ThreatFilters = exports.ItemsPerSearch = exports.ConcurrentSearches = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("../../../../model/primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Threat Match Rule Attributes
 *   version: not applicable
 */

/**
 * Query used to determine which fields in the Elasticsearch index are used for generating alerts.
 */

const ThreatQuery = exports.ThreatQuery = _zod.z.string();
const ThreatMappingEntry = exports.ThreatMappingEntry = _zod.z.object({
  field: _primitives.NonEmptyString,
  type: _zod.z.literal('mapping'),
  value: _primitives.NonEmptyString,
  negate: _zod.z.boolean().optional()
});

/**
  * Array of entries objects that define mappings between the source event fields and the values in the Elasticsearch threat index. Each entries object must contain these fields:

- field: field from the event indices on which the rule runs
- type: must be mapping
- value: field from the Elasticsearch threat index
  
You can use Boolean and and or logic to define the conditions for when matching fields and values generate alerts. Sibling entries objects are evaluated using or logic, whereas multiple entries in a single entries object use and logic. See Example of Threat Match rule which uses both `and` and `or` logic.

  */

const ThreatMapping = exports.ThreatMapping = _zod.z.array(_zod.z.object({
  entries: _zod.z.array(ThreatMappingEntry)
})).min(1);

/**
 * Elasticsearch indices used to check which field values generate alerts.
 */

const ThreatIndex = exports.ThreatIndex = _zod.z.array(_zod.z.string());
const ThreatFilters = exports.ThreatFilters = _zod.z.array(_zod.z.unknown());

/**
 * Defines the path to the threat indicator in the indicator documents (optional)
 */

const ThreatIndicatorPath = exports.ThreatIndicatorPath = _zod.z.string();
const ConcurrentSearches = exports.ConcurrentSearches = _zod.z.number().int().min(1);
const ItemsPerSearch = exports.ItemsPerSearch = _zod.z.number().int().min(1);