"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAssetsNavigationTree = void 0;
var _react = require("react");
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
var _i18n_strings = require("../i18n_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyIconAssets = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./custom_icons/assets'))).then(({
  iconAssets
}) => ({
  default: iconAssets
})));
const createAssetsNavigationTree = core => ({
  id: _constants.SecurityGroupName.assets,
  icon: LazyIconAssets,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.assets].title,
  renderAs: 'panelOpener',
  children: [{
    link: 'fleet',
    title: _i18n_strings.i18nStrings.assets.fleet.title,
    children: [{
      link: 'fleet:agents'
    }, {
      link: 'fleet:policies',
      title: _i18n_strings.i18nStrings.assets.fleet.policies
    }, {
      link: 'fleet:enrollment_tokens'
    }, {
      link: 'fleet:uninstall_tokens'
    }, {
      link: 'fleet:data_streams'
    }, {
      link: 'fleet:settings'
    }]
  }, {
    id: _constants.SecurityPageName.endpoints,
    title: _i18n_strings.i18nStrings.assets.endpoints.title,
    children: [{
      id: _constants.SecurityPageName.endpoints,
      link: (0, _links.securityLink)(_constants.SecurityPageName.endpoints),
      breadcrumbStatus: 'hidden'
    }, {
      id: _constants.SecurityPageName.policies,
      link: (0, _links.securityLink)(_constants.SecurityPageName.policies)
    }, {
      id: _constants.SecurityPageName.trustedApps,
      link: (0, _links.securityLink)(_constants.SecurityPageName.trustedApps)
    }, {
      id: _constants.SecurityPageName.trustedDevices,
      link: (0, _links.securityLink)(_constants.SecurityPageName.trustedDevices)
    }, {
      id: _constants.SecurityPageName.eventFilters,
      link: (0, _links.securityLink)(_constants.SecurityPageName.eventFilters)
    }, {
      id: _constants.SecurityPageName.hostIsolationExceptions,
      link: (0, _links.securityLink)(_constants.SecurityPageName.hostIsolationExceptions)
    }, {
      id: _constants.SecurityPageName.blocklist,
      link: (0, _links.securityLink)(_constants.SecurityPageName.blocklist)
    }, {
      id: _constants.SecurityPageName.endpointExceptions,
      link: (0, _links.securityLink)(_constants.SecurityPageName.endpointExceptions)
    }, {
      id: _constants.SecurityPageName.responseActionsHistory,
      link: (0, _links.securityLink)(_constants.SecurityPageName.responseActionsHistory)
    }, {
      id: _constants.SecurityPageName.scriptsLibrary,
      link: (0, _links.securityLink)(_constants.SecurityPageName.scriptsLibrary)
    }]
  }]
});
exports.createAssetsNavigationTree = createAssetsNavigationTree;