"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rulesDefaultProductFeaturesConfig = void 0;
var _product_features_keys = require("../product_features_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rulesDefaultProductFeaturesConfig = exports.rulesDefaultProductFeaturesConfig = {
  [_product_features_keys.ProductFeatureRulesKey.externalDetections]: {
    privileges: {
      all: {
        ui: ['external_detections'],
        api: []
      },
      read: {
        ui: ['external_detections'],
        api: []
      }
    }
  },
  [_product_features_keys.ProductFeatureRulesKey.detections]: {
    privileges: {
      all: {
        ui: ['detections'],
        api: ['cloud-security-posture-all', 'cloud-security-posture-read', 'bulkGetUserProfiles']
      },
      read: {
        ui: ['detections'],
        api: ['cloud-security-posture-read', 'bulkGetUserProfiles']
      }
    }
  }
};