"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySubFeatureId = exports.ProductFeatureTimelineKey = exports.ProductFeatureSiemMigrationsKey = exports.ProductFeatureSecurityKey = exports.ProductFeatureRulesKey = exports.ProductFeatureNotesKey = exports.ProductFeatureKey = exports.ProductFeatureCasesKey = exports.ProductFeatureAttackDiscoveryKey = exports.ProductFeatureAssistantKey = exports.CasesSubFeatureId = exports.AttackDiscoverySubFeatureId = exports.AssistantSubFeatureId = exports.ALL_PRODUCT_FEATURE_KEYS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ProductFeatureSecurityKey = exports.ProductFeatureSecurityKey = /*#__PURE__*/function (ProductFeatureSecurityKey) {
  ProductFeatureSecurityKey["advancedInsights"] = "advanced_insights";
  ProductFeatureSecurityKey["configurations"] = "configurations";
  ProductFeatureSecurityKey["aiValueReport"] = "ai_value_report";
  ProductFeatureSecurityKey["ruleGapsAutoFill"] = "rule_gaps_auto_fill";
  ProductFeatureSecurityKey["detections"] = "detections";
  ProductFeatureSecurityKey["investigationGuide"] = "investigation_guide";
  ProductFeatureSecurityKey["investigationGuideInteractions"] = "investigation_guide_interactions";
  ProductFeatureSecurityKey["endpointHostManagement"] = "endpoint_host_management";
  ProductFeatureSecurityKey["endpointTrustedDevices"] = "endpoint_trusted_devices";
  ProductFeatureSecurityKey["endpointHostIsolation"] = "endpoint_host_isolation";
  ProductFeatureSecurityKey["endpointPolicyManagement"] = "endpoint_policy_management";
  ProductFeatureSecurityKey["endpointPolicyProtections"] = "endpoint_policy_protections";
  ProductFeatureSecurityKey["endpointArtifactManagement"] = "endpoint_artifact_management";
  ProductFeatureSecurityKey["endpointHostIsolationExceptions"] = "endpoint_host_isolation_exceptions";
  ProductFeatureSecurityKey["endpointResponseActions"] = "endpoint_response_actions";
  ProductFeatureSecurityKey["threatIntelligence"] = "threat-intelligence";
  ProductFeatureSecurityKey["osqueryAutomatedResponseActions"] = "osquery_automated_response_actions";
  ProductFeatureSecurityKey["endpointProtectionUpdates"] = "endpoint_protection_updates";
  ProductFeatureSecurityKey["endpointCustomNotification"] = "endpoint_custom_notification";
  ProductFeatureSecurityKey["endpointAgentTamperProtection"] = "endpoint_agent_tamper_protection";
  ProductFeatureSecurityKey["endpointExceptions"] = "endpointExceptions";
  ProductFeatureSecurityKey["externalRuleActions"] = "external_rule_actions";
  ProductFeatureSecurityKey["cloudSecurityPosture"] = "cloud_security_posture";
  ProductFeatureSecurityKey["automaticImport"] = "automatic_import";
  ProductFeatureSecurityKey["securityWorkflowInsights"] = "security_workflow_insights";
  ProductFeatureSecurityKey["graphVisualization"] = "graph_visualization";
  return ProductFeatureSecurityKey;
}({});
let ProductFeatureCasesKey = exports.ProductFeatureCasesKey = /*#__PURE__*/function (ProductFeatureCasesKey) {
  ProductFeatureCasesKey["casesConnectors"] = "cases_connectors";
  return ProductFeatureCasesKey;
}({});
let ProductFeatureAssistantKey = exports.ProductFeatureAssistantKey = /*#__PURE__*/function (ProductFeatureAssistantKey) {
  ProductFeatureAssistantKey["assistant"] = "assistant";
  return ProductFeatureAssistantKey;
}({});
let ProductFeatureAttackDiscoveryKey = exports.ProductFeatureAttackDiscoveryKey = /*#__PURE__*/function (ProductFeatureAttackDiscoveryKey) {
  ProductFeatureAttackDiscoveryKey["attackDiscovery"] = "attack_discovery";
  return ProductFeatureAttackDiscoveryKey;
}({});
let ProductFeatureTimelineKey = exports.ProductFeatureTimelineKey = /*#__PURE__*/function (ProductFeatureTimelineKey) {
  ProductFeatureTimelineKey["timeline"] = "timeline";
  return ProductFeatureTimelineKey;
}({});
let ProductFeatureNotesKey = exports.ProductFeatureNotesKey = /*#__PURE__*/function (ProductFeatureNotesKey) {
  ProductFeatureNotesKey["notes"] = "notes";
  return ProductFeatureNotesKey;
}({});
let ProductFeatureSiemMigrationsKey = exports.ProductFeatureSiemMigrationsKey = /*#__PURE__*/function (ProductFeatureSiemMigrationsKey) {
  ProductFeatureSiemMigrationsKey["siemMigrations"] = "siem_migrations";
  return ProductFeatureSiemMigrationsKey;
}({});
let ProductFeatureRulesKey = exports.ProductFeatureRulesKey = /*#__PURE__*/function (ProductFeatureRulesKey) {
  ProductFeatureRulesKey["detections"] = "detections";
  ProductFeatureRulesKey["externalDetections"] = "external_detections";
  ProductFeatureRulesKey["prebuiltRuleCustomization"] = "prebuilt_rule_customization";
  return ProductFeatureRulesKey;
}({}); // Merges the two enums.
const ProductFeatureKey = exports.ProductFeatureKey = {
  ...ProductFeatureSecurityKey,
  ...ProductFeatureCasesKey,
  ...ProductFeatureAssistantKey,
  ...ProductFeatureAttackDiscoveryKey,
  ...ProductFeatureSiemMigrationsKey,
  ...ProductFeatureTimelineKey,
  ...ProductFeatureNotesKey,
  ...ProductFeatureRulesKey
};
// We need to merge the value and the type and export both to replicate how enum works.

const ALL_PRODUCT_FEATURE_KEYS = exports.ALL_PRODUCT_FEATURE_KEYS = Object.freeze(Object.values(ProductFeatureKey));

/** Sub-features IDs for Security */
let SecuritySubFeatureId = exports.SecuritySubFeatureId = /*#__PURE__*/function (SecuritySubFeatureId) {
  SecuritySubFeatureId["endpointList"] = "endpointListSubFeature";
  SecuritySubFeatureId["endpointExceptions"] = "endpointExceptionsSubFeature";
  SecuritySubFeatureId["trustedApplications"] = "trustedApplicationsSubFeature";
  SecuritySubFeatureId["trustedDevices"] = "trustedDevicesSubFeature";
  SecuritySubFeatureId["hostIsolationExceptionsBasic"] = "hostIsolationExceptionsBasicSubFeature";
  SecuritySubFeatureId["blocklist"] = "blocklistSubFeature";
  SecuritySubFeatureId["eventFilters"] = "eventFiltersSubFeature";
  SecuritySubFeatureId["globalArtifactManagement"] = "globalArtifactManagementSubFeature";
  SecuritySubFeatureId["policyManagement"] = "policyManagementSubFeature";
  SecuritySubFeatureId["responseActionsHistory"] = "responseActionsHistorySubFeature";
  SecuritySubFeatureId["workflowInsights"] = "workflowInsightsSubFeature";
  SecuritySubFeatureId["socManagement"] = "socManagementSubFeature";
  SecuritySubFeatureId["hostIsolation"] = "hostIsolationSubFeature";
  SecuritySubFeatureId["processOperations"] = "processOperationsSubFeature";
  SecuritySubFeatureId["fileOperations"] = "fileOperationsSubFeature";
  SecuritySubFeatureId["executeAction"] = "executeActionSubFeature";
  SecuritySubFeatureId["scanAction"] = "scanActionSubFeature";
  return SecuritySubFeatureId;
}({});
/** Sub-features IDs for Cases */
let CasesSubFeatureId = exports.CasesSubFeatureId = /*#__PURE__*/function (CasesSubFeatureId) {
  CasesSubFeatureId["deleteCases"] = "deleteCasesSubFeature";
  CasesSubFeatureId["casesSettings"] = "casesSettingsSubFeature";
  CasesSubFeatureId["createComment"] = "createCommentSubFeature";
  CasesSubFeatureId["reopenCase"] = "reopenCaseSubFeature";
  CasesSubFeatureId["assignUsers"] = "assignUsersSubFeature";
  return CasesSubFeatureId;
}({});
/** Sub-features IDs for Security Assistant */
let AssistantSubFeatureId = exports.AssistantSubFeatureId = /*#__PURE__*/function (AssistantSubFeatureId) {
  AssistantSubFeatureId["updateAnonymization"] = "updateAnonymizationSubFeature";
  AssistantSubFeatureId["manageGlobalKnowledgeBase"] = "manageGlobalKnowledgeBaseSubFeature";
  return AssistantSubFeatureId;
}({});
/** Sub-features IDs for Security Attack Discovery */
let AttackDiscoverySubFeatureId = exports.AttackDiscoverySubFeatureId = /*#__PURE__*/function (AttackDiscoverySubFeatureId) {
  AttackDiscoverySubFeatureId["updateSchedule"] = "updateScheduleSubFeature";
  return AttackDiscoverySubFeatureId;
}({});