"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERS_API_READ = exports.TIMELINE_FEATURE_ID = exports.SIEM_MIGRATIONS_FEATURE_ID = exports.SERVER_APP_ID = exports.SECURITY_UI_SHOW_PRIVILEGE = exports.SECURITY_UI_SHOW = exports.SECURITY_UI_CRUD_PRIVILEGE = exports.SECURITY_UI_CRUD = exports.SECURITY_SOLUTION_CASES_APP_ID = exports.SECURITY_FEATURE_ID_V5 = exports.SECURITY_FEATURE_ID_V4 = exports.SECURITY_FEATURE_ID_V3 = exports.SECURITY_FEATURE_ID_V2 = exports.RULES_UI_READ_PRIVILEGE = exports.RULES_UI_READ = exports.RULES_UI_EXTERNAL_DETECTIONS_PRIVILEGE = exports.RULES_UI_EXTERNAL_DETECTIONS = exports.RULES_UI_EDIT_PRIVILEGE = exports.RULES_UI_EDIT = exports.RULES_UI_DETECTIONS_PRIVILEGE = exports.RULES_UI_DETECTIONS = exports.RULES_FEATURE_ID = exports.RULES_API_READ = exports.RULES_API_ALL = exports.NOTES_FEATURE_ID = exports.LISTS_API_SUMMARY = exports.LISTS_API_READ = exports.LISTS_API_ALL = exports.LEGACY_NOTIFICATIONS_ID = exports.INITIALIZE_SECURITY_SOLUTION = exports.EXCEPTIONS_API_READ = exports.EXCEPTIONS_API_ALL = exports.CLOUD_POSTURE_APP_ID = exports.CLOUD_DEFEND_APP_ID = exports.CASES_FEATURE_ID_V3 = exports.CASES_FEATURE_ID_V2 = exports.CASES_FEATURE_ID = exports.ATTACK_DISCOVERY_FEATURE_ID = exports.ASSISTANT_FEATURE_ID = exports.APP_ID = exports.ALERTS_API_READ = exports.ALERTS_API_ALL = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Same as the plugin id defined by Security Solution
const APP_ID = exports.APP_ID = 'securitySolution';
const SERVER_APP_ID = exports.SERVER_APP_ID = 'siem';

// New version created in 8.18. It was previously `SERVER_APP_ID`.
const SECURITY_FEATURE_ID_V2 = exports.SECURITY_FEATURE_ID_V2 = 'siemV2';
// New version for 9.1.
const SECURITY_FEATURE_ID_V3 = exports.SECURITY_FEATURE_ID_V3 = 'siemV3';
// New version for 9.2.
const SECURITY_FEATURE_ID_V4 = exports.SECURITY_FEATURE_ID_V4 = 'siemV4';
// New version for 9.3.
const SECURITY_FEATURE_ID_V5 = exports.SECURITY_FEATURE_ID_V5 = 'siemV5';

// Security UI privileges
const SECURITY_UI_SHOW = exports.SECURITY_UI_SHOW = 'show';
const SECURITY_UI_SHOW_PRIVILEGE = exports.SECURITY_UI_SHOW_PRIVILEGE = `${SECURITY_FEATURE_ID_V5}.${SECURITY_UI_SHOW}`;
const SECURITY_UI_CRUD = exports.SECURITY_UI_CRUD = 'crud';
const SECURITY_UI_CRUD_PRIVILEGE = exports.SECURITY_UI_CRUD_PRIVILEGE = `${SECURITY_FEATURE_ID_V5}.${SECURITY_UI_CRUD}`;

/**
 * @deprecated deprecated in 8.17. Use CASE_FEATURE_ID_V2 instead
 */
const CASES_FEATURE_ID = exports.CASES_FEATURE_ID = 'securitySolutionCases';

// New version created in 8.17 to adopt the roles migration changes
const CASES_FEATURE_ID_V2 = exports.CASES_FEATURE_ID_V2 = 'securitySolutionCasesV2';

// New version created in 8.18 for case assignees
const CASES_FEATURE_ID_V3 = exports.CASES_FEATURE_ID_V3 = 'securitySolutionCasesV3';
const SECURITY_SOLUTION_CASES_APP_ID = exports.SECURITY_SOLUTION_CASES_APP_ID = 'securitySolutionCases';
const ASSISTANT_FEATURE_ID = exports.ASSISTANT_FEATURE_ID = 'securitySolutionAssistant';
const ATTACK_DISCOVERY_FEATURE_ID = exports.ATTACK_DISCOVERY_FEATURE_ID = 'securitySolutionAttackDiscovery';
const TIMELINE_FEATURE_ID = exports.TIMELINE_FEATURE_ID = 'securitySolutionTimeline';
const NOTES_FEATURE_ID = exports.NOTES_FEATURE_ID = 'securitySolutionNotes';
const SIEM_MIGRATIONS_FEATURE_ID = exports.SIEM_MIGRATIONS_FEATURE_ID = 'securitySolutionSiemMigrations';
const RULES_FEATURE_ID = exports.RULES_FEATURE_ID = 'securitySolutionRulesV1';

// Rules API privileges
const RULES_API_READ = exports.RULES_API_READ = 'rules-read';
const RULES_API_ALL = exports.RULES_API_ALL = 'rules-all';
const ALERTS_API_READ = exports.ALERTS_API_READ = 'alerts-read';
const ALERTS_API_ALL = exports.ALERTS_API_ALL = 'alerts-all';
const EXCEPTIONS_API_READ = exports.EXCEPTIONS_API_READ = 'exceptions-read';
const EXCEPTIONS_API_ALL = exports.EXCEPTIONS_API_ALL = 'exceptions-all';
const LISTS_API_READ = exports.LISTS_API_READ = 'lists-read';
const LISTS_API_ALL = exports.LISTS_API_ALL = 'lists-all';
const LISTS_API_SUMMARY = exports.LISTS_API_SUMMARY = 'lists-summary';
const INITIALIZE_SECURITY_SOLUTION = exports.INITIALIZE_SECURITY_SOLUTION = 'initialize-security-solution';
const USERS_API_READ = exports.USERS_API_READ = 'users-read';

// Rules UI privileges
const RULES_UI_READ = exports.RULES_UI_READ = 'read_rules';
const RULES_UI_DETECTIONS = exports.RULES_UI_DETECTIONS = 'detections';
const RULES_UI_EXTERNAL_DETECTIONS = exports.RULES_UI_EXTERNAL_DETECTIONS = 'external_detections';
const RULES_UI_READ_PRIVILEGE = exports.RULES_UI_READ_PRIVILEGE = `${RULES_FEATURE_ID}.${RULES_UI_READ}`;
const RULES_UI_EDIT = exports.RULES_UI_EDIT = 'edit_rules';
const RULES_UI_EDIT_PRIVILEGE = exports.RULES_UI_EDIT_PRIVILEGE = `${RULES_FEATURE_ID}.${RULES_UI_EDIT}`;
const RULES_UI_DETECTIONS_PRIVILEGE = exports.RULES_UI_DETECTIONS_PRIVILEGE = `${RULES_FEATURE_ID}.${RULES_UI_DETECTIONS}`;
const RULES_UI_EXTERNAL_DETECTIONS_PRIVILEGE = exports.RULES_UI_EXTERNAL_DETECTIONS_PRIVILEGE = `${RULES_FEATURE_ID}.${RULES_UI_EXTERNAL_DETECTIONS}`;

// Same as the plugin id defined by Cloud Security Posture
const CLOUD_POSTURE_APP_ID = exports.CLOUD_POSTURE_APP_ID = 'csp';

// Same as the plugin id defined by Defend for containers (cloud_defend)
const CLOUD_DEFEND_APP_ID = exports.CLOUD_DEFEND_APP_ID = 'cloudDefend';

/**
 * Id for the notifications alerting type
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 */
const LEGACY_NOTIFICATIONS_ID = exports.LEGACY_NOTIFICATIONS_ID = `siem.notifications`;