"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SavedObjectsSecurityExtension", {
  enumerable: true,
  get: function () {
    return _saved_objects_security_extension.SavedObjectsSecurityExtension;
  }
});
Object.defineProperty(exports, "SecurityAction", {
  enumerable: true,
  get: function () {
    return _types.SecurityAction;
  }
});
exports.setupSavedObjects = setupSavedObjects;
var _server = require("@kbn/core/server");
var _access_control_transforms = require("./access_control_transforms");
var _saved_objects_security_extension = require("./saved_objects_security_extension");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setupSavedObjects({
  audit,
  authz,
  savedObjects,
  getCurrentUser
}) {
  savedObjects.setClientFactoryProvider(
  // This is not used by Kibana itself, but it can be leveraged for Kibana to use a third-party authentication header if there is a custom
  // authentication layer sitting between Kibana and Elasticsearch, and if Elasticsearch security is disabled. It's unclear if it's even
  // possible for that to function anymore, perhaps we should deprecate this custom client factory provider and remove it in 9.0?
  repositoryFactory => ({
    request,
    includedHiddenTypes,
    extensions
  }) => {
    return new _server.SavedObjectsClient(authz.mode.useRbacForRequest(request) ? repositoryFactory.createInternalRepository(includedHiddenTypes, extensions) : repositoryFactory.createScopedRepository(request, includedHiddenTypes, extensions));
  });
  savedObjects.setSecurityExtension(({
    request,
    typeRegistry
  }) => {
    return authz.mode.useRbacForRequest(request) ? new _saved_objects_security_extension.SavedObjectsSecurityExtension({
      actions: authz.actions,
      auditLogger: audit.asScoped(request),
      checkPrivileges: authz.checkSavedObjectsPrivilegesWithRequest(request),
      errors: _server.SavedObjectsClient.errors,
      getCurrentUser: () => getCurrentUser(request),
      typeRegistry
    }) : undefined;
  });
  savedObjects.setAccessControlTransforms({
    createImportTransforms: (0, _access_control_transforms.getImportTransformsFactory)()
  });
}