"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGE_ACCESS_CONTROL_ACTION = exports.AccessControlService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MANAGE_ACCESS_CONTROL_ACTION = exports.MANAGE_ACCESS_CONTROL_ACTION = 'manage_access_control';
const UPDATE_ACTION = 'update';
class AccessControlService {
  constructor({
    typeRegistry
  }) {
    (0, _defineProperty2.default)(this, "userForOperation", null);
    (0, _defineProperty2.default)(this, "typeRegistry", void 0);
    this.typeRegistry = typeRegistry;
  }
  setUserForOperation(user) {
    this.userForOperation = user;
  }
  shouldObjectRequireAccessControl(params) {
    var _this$typeRegistry;
    const {
      object,
      currentUser,
      actions
    } = params;
    if (!((_this$typeRegistry = this.typeRegistry) !== null && _this$typeRegistry !== void 0 && _this$typeRegistry.supportsAccessControl(object.type))) {
      return false;
    }
    const {
      accessControl
    } = object;
    if (!accessControl) {
      return false;
    }
    const actionsIgnoringDefaultMode = new Set([_.SecurityAction.CREATE, _.SecurityAction.BULK_CREATE, _.SecurityAction.UPDATE, _.SecurityAction.BULK_UPDATE, _.SecurityAction.DELETE, _.SecurityAction.BULK_DELETE]);
    const anyActionsForcingDefaultCheck = Array.from(actions).some(item => !actionsIgnoringDefaultMode.has(item));
    if (!anyActionsForcingDefaultCheck && accessControl.accessMode === 'default') {
      return false;
    }
    return !currentUser || accessControl.owner !== currentUser.profile_uid;
  }
  getObjectsRequiringPrivilegeCheck({
    objects,
    actions
  }) {
    if (!this.typeRegistry) {
      return {
        types: new Set(),
        objects: []
      };
    }
    const currentUser = this.userForOperation;
    const typesRequiringAccessControl = new Set();
    const results = objects.map(object => {
      const requiresManageAccessControl = this.shouldObjectRequireAccessControl({
        object,
        currentUser,
        actions
      });
      if (requiresManageAccessControl) {
        typesRequiringAccessControl.add(object.type);
      }
      return {
        type: object.type,
        id: object.id,
        ...(object.name && {
          name: object.name
        }),
        requiresManageAccessControl
      };
    });
    return {
      types: typesRequiringAccessControl,
      objects: results
    };
  }
  enforceAccessControl({
    authorizationResult,
    typesRequiringAccessControl,
    typesRequiringRbac,
    currentSpace,
    addAuditEventFn
  }) {
    if (authorizationResult.status === 'unauthorized') {
      const typeList = [...new Set([...typesRequiringAccessControl, ...typesRequiringRbac])].sort();
      addAuditEventFn === null || addAuditEventFn === void 0 ? void 0 : addAuditEventFn(typeList);
      throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.decorateForbiddenError(new Error(`Access denied: Unable to manage access control for ${typeList}`));
    }
    const {
      typeMap
    } = authorizationResult;
    const unauthorizedTypes = new Set();
    const addUnauthorizedTypes = (type, action) => {
      const typeAuth = typeMap.get(type);
      const actionAuth = typeAuth === null || typeAuth === void 0 ? void 0 : typeAuth[action];
      if (!actionAuth) {
        unauthorizedTypes.add(type);
      } else {
        // Check if user has global authorization or authorization in the current space
        if (!actionAuth.isGloballyAuthorized && (!actionAuth.authorizedSpaces || !actionAuth.authorizedSpaces.includes(currentSpace))) {
          unauthorizedTypes.add(type);
        }
      }
    };
    for (const type of typesRequiringAccessControl) {
      var _this$typeRegistry2;
      if (!((_this$typeRegistry2 = this.typeRegistry) !== null && _this$typeRegistry2 !== void 0 && _this$typeRegistry2.supportsAccessControl(type))) {
        continue;
      }
      addUnauthorizedTypes(type, MANAGE_ACCESS_CONTROL_ACTION);
    }
    for (const type of typesRequiringRbac) {
      addUnauthorizedTypes(type, UPDATE_ACTION);
    }

    // If we found unauthorized types, throw an error
    if (unauthorizedTypes.size > 0) {
      const typeList = [...unauthorizedTypes].sort();
      addAuditEventFn === null || addAuditEventFn === void 0 ? void 0 : addAuditEventFn(typeList);
      throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.decorateForbiddenError(new Error(`Access denied: Unable to manage access control for ${typeList}`));
    }
  }
}
exports.AccessControlService = AccessControlService;