"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteUsers = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _std = require("@kbn/std");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/users/components/confirm_delete_users/confirm_delete_users.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ConfirmDeleteUsers extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "deleteUsers", () => {
      const {
        usersToDelete,
        callback,
        userAPIClient,
        notifications
      } = this.props;
      const errors = [];
      (0, _std.asyncForEach)(usersToDelete, async username => {
        try {
          await userAPIClient.deleteUser(username);
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.users.confirmDelete.userSuccessfullyDeletedNotificationMessage', {
            defaultMessage: 'Deleted user {username}',
            values: {
              username
            }
          }));
        } catch (e) {
          errors.push(username);
          notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.users.confirmDelete.userDeletingErrorNotificationMessage', {
            defaultMessage: 'Error deleting user {username}',
            values: {
              username
            }
          }));
        }
      }).then(() => {
        if (callback) {
          callback(usersToDelete, errors);
        }
      });
    });
  }
  render() {
    const {
      usersToDelete,
      onCancel
    } = this.props;
    const moreThanOne = usersToDelete.length > 1;
    const title = moreThanOne ? _i18n.i18n.translate('xpack.security.management.users.confirmDelete.deleteMultipleUsersTitle', {
      defaultMessage: 'Delete {userLength} users',
      values: {
        userLength: usersToDelete.length
      }
    }) : _i18n.i18n.translate('xpack.security.management.users.confirmDelete.deleteOneUserTitle', {
      defaultMessage: 'Delete user {userLength}',
      values: {
        userLength: usersToDelete[0]
      }
    });
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: title,
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: onCancel,
      onConfirm: this.deleteUsers,
      cancelButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDelete.cancelButtonLabel', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDelete.confirmButtonLabel', {
        defaultMessage: 'Delete'
      }),
      buttonColor: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, moreThanOne ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.confirmDelete.removingUsersDescription",
      defaultMessage: "You are about to delete these users:",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }, usersToDelete.map(username => /*#__PURE__*/_react.default.createElement("li", {
      key: username,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 19
      }
    }, username)))) : null, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.confirmDelete.removingUsersWarningMessage",
      defaultMessage: "This operation cannot be undone.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    }))));
  }
}
exports.ConfirmDeleteUsers = ConfirmDeleteUsers;