"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfile = exports.SaveChangesBottomBar = void 0;
exports.useUserProfileForm = useUserProfileForm;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _formik = require("formik");
var _react2 = _interopRequireWildcard(require("react"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _securityFormComponents = require("@kbn/security-form-components");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _userProfileComponents = require("@kbn/user-profile-components");
var _utils = require("./utils");
var _constants = require("../../../common/constants");
var _model = require("../../../common/model");
var _components = require("../../components");
var _breadcrumb = require("../../components/breadcrumb");
var _change_password_modal = require("../../management/users/edit_user/change_password_modal");
var _user_utils = require("../../management/users/user_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/account_management/user_profile/user_profile.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formRowCSS = (0, _react.css)`
  .euiFormRow__label {
    flex: 1;
  }
`;
const pageHeaderCSS = (0, _react.css)`
  border-bottom: none;

  .euiPageHeaderContent {
    max-width: 1248px;
    margin: auto;
  }
`;
const betaBadgeCSS = ({
  euiTheme
}) => (0, _react.css)`
  padding: calc(${euiTheme.size.xxs} * 1.5);
  border: ${euiTheme.border.width.thin} solid ${euiTheme.border.color};
  border-radius: 50%;
`;
const UserDetailsEditor = ({
  user
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const canChangeDetails = (0, _model.canUserChangeDetails)(user, services.application.capabilities);
  if (!canChangeDetails) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.detailsGroupTitle",
      defaultMessage: "Details",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.detailsGroupDescription",
      defaultMessage: "Provide some basic information about yourself.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    css: formRowCSS,
    label: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
      for: "user.full_name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.fullNameLabel",
      defaultMessage: "Full name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_securityFormComponents.OptionalText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 15
      }
    }))),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormField, {
    name: "user.full_name",
    "data-test-subj": 'userProfileFullName',
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    css: formRowCSS,
    label: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
      for: "user.email",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.emailLabel",
      defaultMessage: "Email address",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_securityFormComponents.OptionalText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 15
      }
    }))),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormField, {
    type: "email",
    name: "user.email",
    "data-test-subj": 'userProfileEmail',
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  })));
};
const UserSettingsEditor = ({
  formik,
  isThemeOverridden,
  isOverriddenThemeDarkMode
}) => {
  if (!formik.values.data) {
    return null;
  }
  let colorModeIdSelected = formik.values.data.userSettings.darkMode;
  if (isThemeOverridden) {
    if (isOverriddenThemeDarkMode) {
      colorModeIdSelected = 'dark';
    } else {
      colorModeIdSelected = 'light';
    }
  }
  const themeItem = ({
    id,
    label,
    icon
  }) => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiKeyPadMenuItem, {
      name: id,
      label: label,
      "data-test-subj": `themeKeyPadItem${id}`,
      checkable: "single",
      isSelected: colorModeIdSelected === id,
      isDisabled: isThemeOverridden,
      onChange: () => formik.setFieldValue('data.userSettings.darkMode', id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: icon,
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 9
      }
    }));
  };
  const themeMenu = themeOverridden => {
    const themeKeyPadMenu = /*#__PURE__*/_react2.default.createElement(_eui.EuiKeyPadMenu, {
      "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.userProfile.userSettings.themeGroupDescription', {
        defaultMessage: 'Elastic theme'
      }),
      "data-test-subj": "themeMenu",
      checkable: {
        legend: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
          for: "data.userSettings.darkMode",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 251,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.accountManagement.userProfile.userSettings.theme",
          defaultMessage: "Color mode",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 252,
            columnNumber: 15
          }
        }))
      },
      css: (0, _react.css)`
          inline-size: 420px; // Allow for 4 items to fit in a row instead of the default 3
        `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 7
      }
    }, themeItem({
      id: 'system',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.systemModeButton', {
        defaultMessage: 'System'
      }),
      icon: 'desktop'
    }), themeItem({
      id: 'light',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.lightModeButton', {
        defaultMessage: 'Light'
      }),
      icon: 'sun'
    }), themeItem({
      id: 'dark',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.darkModeButton', {
        defaultMessage: 'Dark'
      }),
      icon: 'moon'
    }), themeItem({
      id: 'space_default',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.defaultModeButton', {
        defaultMessage: 'Space default'
      }),
      icon: 'spaces'
    }));
    return themeOverridden ? /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "themeOverrideTooltip",
      content: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.overriddenMessage",
        defaultMessage: "This setting is overridden by the Kibana server and can not be changed.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 297,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 7
      }
    }, themeKeyPadMenu) : themeKeyPadMenu;
  };
  const deprecatedWarning = colorModeIdSelected === 'space_default' && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.deprecatedSpaceDefaultTitle', {
      defaultMessage: 'Space default settings will be removed in a future version'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.security.accountManagement.userProfile.deprecatedSpaceDefaultDescription', {
    defaultMessage: 'All users with the Space default color mode enabled will be automatically transitioned to the System color mode.'
  }))));
  const contrastModeIdSelected = formik.values.data.userSettings.contrastMode;
  const contrastItem = ({
    id,
    label,
    icon
  }) => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiKeyPadMenuItem, {
      name: id,
      label: label,
      "data-test-subj": `contrastKeyPadItem${id}`,
      checkable: "single",
      isSelected: contrastModeIdSelected === id,
      onChange: () => formik.setFieldValue('data.userSettings.contrastMode', id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: icon,
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 9
      }
    }));
  };
  const contrastModeMenu = () => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiKeyPadMenu, {
      "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.userProfile.userSettings.interfaceContrastGroupDescription', {
        defaultMessage: 'Interface contrast'
      }),
      "data-test-subj": "contrastMenu",
      checkable: {
        legend: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
          for: "data.userSettings.contrastMode",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 365,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 366,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          grow: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 367,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.accountManagement.userProfile.userSettings.contrastMode",
          defaultMessage: "Interface contrast",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 368,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 373,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react2.default.createElement("div", {
          css: betaBadgeCSS,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 374,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
          "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.userProfile.userSettings.contrastMode.betaBadge', {
            defaultMessage: 'beta'
          }),
          content: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.userSettings.contrastMode.betaBadge.tooltip', {
            defaultMessage: 'The contrast setting is currently a beta feature.'
          }),
          type: "beta",
          position: "bottom",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 375,
            columnNumber: 21
          }
        })))))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 7
      }
    }, contrastItem({
      id: 'system',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.contrastModeSystemButton', {
        defaultMessage: 'System'
      }),
      icon: 'desktop'
    }), contrastItem({
      id: 'standard',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.contrastModeStandardButton', {
        defaultMessage: 'Normal'
      }),
      icon: 'contrast'
    }), contrastItem({
      id: 'high',
      label: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.contrastModeHighButton', {
        defaultMessage: 'High'
      }),
      icon: 'contrastHigh'
    }));
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    fieldFlexItemProps: {
      style: {
        alignSelf: 'flex-start'
      }
    },
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 427,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.userSettingsTitle",
      defaultMessage: "Appearance",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.themeFormGroupDescription",
      defaultMessage: "Select the appearance of your interface.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 435,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    name: "data.userSettings.darkMode",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, themeMenu(isThemeOverridden), deprecatedWarning)), /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    name: "data.userSettings.contrastMode",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 7
    }
  }, contrastModeMenu()));
};
function UserAvatarEditor({
  user,
  formik
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!formik.values.data) {
    return null;
  }
  const isReservedUser = (0, _user_utils.isUserReserved)(user);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    fieldFlexItemProps: {
      style: {
        alignSelf: 'flex-start'
      }
    },
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 473,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.avatarGroupTitle",
      defaultMessage: "Avatar",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.avatarGroupDescription",
      defaultMessage: "Provide your initials or upload an image to represent yourself.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 481,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 487,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 9
    }
  }, formik.values.avatarType === 'image' && !formik.values.data.avatar.imageUrl ? /*#__PURE__*/_react2.default.createElement(_userProfileComponents.UserAvatar, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 490,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react2.default.createElement(_userProfileComponents.UserAvatar, {
    user: {
      username: user.username,
      full_name: formik.values.user.full_name
    },
    avatar: {
      imageUrl: formik.values.avatarType === 'image' ? formik.values.data.avatar.imageUrl : undefined,
      initials: formik.values.data.avatar.initials || '?',
      color: _utils.VALID_HEX_COLOR.test(formik.values.data.avatar.color) ? formik.values.data.avatar.color : undefined
    },
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 511,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    name: "avatarType",
    label: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
      for: "avatarType",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 515,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.avatarTypeGroupDescription",
      defaultMessage: "Avatar type",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 516,
        columnNumber: 17
      }
    })),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 512,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.avatarTypeGroupDescription', {
      defaultMessage: 'Avatar type'
    }),
    buttonSize: "m",
    idSelected: formik.values.avatarType,
    options: [{
      id: 'initials',
      label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.initialsAvatarTypeLabel",
        defaultMessage: "Initials",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 535,
          columnNumber: 21
        }
      })
    }, {
      id: 'image',
      label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.accountManagement.userProfile.imageAvatarTypeLabel",
        defaultMessage: "Image",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 544,
          columnNumber: 21
        }
      }),
      iconType: 'image'
    }],
    onChange: id => formik.setFieldValue('avatarType', id),
    isFullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 524,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 558,
      columnNumber: 7
    }
  }), formik.values.avatarType === 'image' ? /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    label: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
      for: "data.avatar.imageUrl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 563,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.imageUrlLabel",
      defaultMessage: "Image",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 564,
        columnNumber: 15
      }
    })),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 561,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormField, {
    as: _eui.EuiFilePicker,
    name: "data.avatar.imageUrl",
    value: undefined /* EuiFilePicker breaks if value is provided  */,
    initialPromptText: formik.values.data.avatar.imageUrl ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.prepopulatedImageUrlPromptText",
      defaultMessage: "Select or drag and drop a replacement image",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 578,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.imageUrlPromptText",
      defaultMessage: "Select or drag and drop an image",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 583,
        columnNumber: 17
      }
    }),
    onChange: (0, _utils.createImageHandler)(imageUrl => {
      if (!imageUrl) {
        formik.setFieldError('data.avatar.imageUrl', _i18n.i18n.translate('xpack.security.accountManagement.userProfile.imageUrlRequiredError', {
          defaultMessage: 'Upload an image.'
        }));
        formik.setFieldTouched('data.avatar.imageUrl', true);
      } else {
        formik.setFieldValue('data.avatar.imageUrl', imageUrl !== null && imageUrl !== void 0 ? imageUrl : '');
      }
    }),
    validate: {
      required: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.imageUrlRequiredError', {
        defaultMessage: 'Upload an image.'
      })
    },
    accept: _constants.IMAGE_FILE_TYPES.join(','),
    display: "default",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 572,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 615,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      width: 64
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    label: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
      for: "data.avatar.initials",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 619,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.initialsLabel",
      defaultMessage: "Initials",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 620,
        columnNumber: 19
      }
    })),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 617,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormField, {
    name: "data.avatar.initials",
    maxLength: 2,
    validate: {
      required: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.initialsRequiredError', {
        defaultMessage: 'Add initials'
      }),
      maxLength: {
        value: 2,
        message: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.initialsMaxLengthError', {
          defaultMessage: 'Enter no more than 2 characters.'
        })
      }
    },
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 648,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormRow, {
    label: /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormLabel, {
      for: "data.avatar.color",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 651,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.colorLabel",
      defaultMessage: "Color",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 652,
        columnNumber: 19
      }
    })),
    labelAppend: !isReservedUser ? /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => formik.setFieldValue('data.avatar.color', (0, _utils.getRandomColor)()),
      size: "xs",
      flush: "right",
      css: {
        height: euiTheme.base
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 660,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.randomizeButton",
      defaultMessage: "Randomize",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 666,
        columnNumber: 21
      }
    })) : null,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 649,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormField, {
    as: _eui.EuiColorPicker,
    name: "data.avatar.color",
    color: formik.values.data.avatar.color,
    validate: {
      required: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.colorRequiredError', {
        defaultMessage: 'Select a color.'
      }),
      pattern: {
        value: _utils.VALID_HEX_COLOR,
        message: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.colorPatternError', {
          defaultMessage: 'Enter a valid HEX color code.'
        })
      }
    },
    onChange: value => {
      formik.setFieldValue('data.avatar.color', value);
    },
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 675,
      columnNumber: 15
    }
  })))));
}
function UserPasswordEditor({
  user,
  onShowPasswordForm
}) {
  const canChangePassword = (0, _model.canUserChangePassword)(user);
  if (!canChangePassword) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 721,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.passwordGroupTitle",
      defaultMessage: "Password",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 722,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.passwordGroupDescription",
      defaultMessage: "Protect your data with a strong password.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 729,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 718,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.passwordLabel",
      defaultMessage: "Password",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 737,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 735,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    onClick: onShowPasswordForm,
    iconType: "lock",
    "data-test-subj": "openChangePasswordForm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 744,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.changePasswordButton",
    defaultMessage: "Change password",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 749,
      columnNumber: 11
    }
  }))));
}
const UserRoles = ({
  user
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const firstThreeRoles = user.roles.slice(0, 3);
  const remainingRoles = user.roles.slice(3);
  const renderMoreRoles = () => {
    const button = /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
      onClick: onButtonClick,
      "data-test-subj": "userRolesExpand",
      onClickAriaLabel: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.showMoreRolesHelpText', {
        defaultMessage: 'Show more roles'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 770,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.userProfile.rolesCountLabel",
      defaultMessage: "+{count}",
      values: {
        count: remainingRoles.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 780,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
      panelPaddingSize: "s",
      button: button,
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      "data-test-subj": "userRolesPopover",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 788,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadgeGroup, {
      gutterSize: "xs",
      "data-test-subj": "remainingRoles",
      css: {
        maxWidth: '200px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 795,
        columnNumber: 9
      }
    }, remainingRoles.map(role => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: role,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 803,
        columnNumber: 13
      }
    }, role))));
  };
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "xs",
    "data-test-subj": "displayedRoles",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 814,
      columnNumber: 7
    }
  }, firstThreeRoles.map(role => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    key: role,
    color: "hollow",
    "data-test-subj": `role${role}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 816,
      columnNumber: 11
    }
  }, role)), remainingRoles.length ? renderMoreRoles() : null));
};
const UserProfile = ({
  user,
  data
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const formik = useUserProfileForm({
    user,
    data
  });
  const formChanges = (0, _securityFormComponents.useFormChanges)();
  const titleId = (0, _eui.useGeneratedHtmlId)();
  const [showChangePasswordForm, setShowChangePasswordForm] = (0, _react2.useState)(false);
  const isCloudUser = user.elastic_cloud_user;
  const {
    isThemeOverridden,
    isOverriddenThemeDarkMode
  } = determineIfThemeOverridden(services.settings.client, services.theme);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_formik.FormikProvider, {
    value: formik,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 842,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_securityFormComponents.FormChangesProvider, {
    value: formChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 843,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_breadcrumb.Breadcrumb, {
    text: user.username,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 844,
      columnNumber: 11
    }
  }, showChangePasswordForm ? /*#__PURE__*/_react2.default.createElement(_change_password_modal.ChangePasswordModal, {
    username: user.username,
    onCancel: () => setShowChangePasswordForm(false),
    onSuccess: () => setShowChangePasswordForm(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 846,
      columnNumber: 15
    }
  }) : null, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    className: "eui-fullHeight",
    restrictWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 853,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    id: titleId,
    css: pageHeaderCSS,
    pageTitle: user.username,
    alignItems: "bottom",
    pageTitleProps: {
      'data-test-subj': 'username',
      'aria-label': _i18n.i18n.translate('xpack.security.accountManagement.userProfile.usernameLabel', {
        defaultMessage: 'Username'
      })
    },
    description: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      component: "span",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 869,
        columnNumber: 19
      }
    }, user.full_name && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      "data-test-subj": "full_name",
      component: "span",
      "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.userProfile.fullNameLabel', {
        defaultMessage: 'Full name'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 871,
        columnNumber: 23
      }
    }, user.full_name), user.full_name && user.email && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      component: "span",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 884,
        columnNumber: 54
      }
    }, ", "), user.email && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      "data-test-subj": "email",
      component: "span",
      "aria-label": _i18n.i18n.translate('xpack.security.accountManagement.userProfile.emailLabel', {
        defaultMessage: 'Email address'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 886,
        columnNumber: 23
      }
    }, user.email)),
    rightSideItems: [/*#__PURE__*/_react2.default.createElement(_eui.EuiDescriptionList, {
      type: "column",
      "data-test-subj": "userRoles",
      listItems: [{
        title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.accountManagement.userProfile.rolesLabel",
          defaultMessage: "{roles, plural, one {Role} other {Roles} }",
          values: {
            roles: user.roles.length
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 908,
            columnNumber: 27
          }
        }),
        description: /*#__PURE__*/_react2.default.createElement(UserRoles, {
          user: user,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 917,
            columnNumber: 38
          }
        })
      }],
      compressed: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 902,
        columnNumber: 19
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 854,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 924,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_formik.Form, {
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 925,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(UserDetailsEditor, {
    user: user,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 926,
      columnNumber: 19
    }
  }), isCloudUser ? null : /*#__PURE__*/_react2.default.createElement(UserAvatarEditor, {
    user: user,
    formik: formik,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 927,
      columnNumber: 41
    }
  }), /*#__PURE__*/_react2.default.createElement(UserPasswordEditor, {
    user: user,
    onShowPasswordForm: () => setShowChangePasswordForm(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 928,
      columnNumber: 19
    }
  }), isCloudUser ? null : /*#__PURE__*/_react2.default.createElement(UserSettingsEditor, {
    formik: formik,
    isThemeOverridden: isThemeOverridden,
    isOverriddenThemeDarkMode: isOverriddenThemeDarkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 933,
      columnNumber: 21
    }
  }))), formChanges.count > 0 ? /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    paddingSize: "m",
    position: "fixed",
    "data-test-subj": 'userProfileBottomBar',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 942,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(SaveChangesBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 947,
      columnNumber: 19
    }
  })) : null)))));
};
exports.UserProfile = UserProfile;
function useUserProfileForm({
  user,
  data
}) {
  var _data$avatar, _data$avatar2, _data$avatar3, _data$userSettings, _data$userSettings2, _data$avatar4, _data$avatar5, _data$avatar6, _formik$values$data;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    users
  } = (0, _components.useSecurityApiClients)();
  const {
    update,
    showSuccessNotification
  } = (0, _userProfileComponents.useUpdateUserProfile)({
    notificationSuccess: {
      enabled: false
    }
  });
  const [initialValues, resetInitialValues] = (0, _react2.useState)({
    user: {
      full_name: user.full_name || '',
      email: user.email || ''
    },
    data: data ? {
      avatar: {
        initials: ((_data$avatar = data.avatar) === null || _data$avatar === void 0 ? void 0 : _data$avatar.initials) || (0, _model.getUserAvatarInitials)(user),
        color: ((_data$avatar2 = data.avatar) === null || _data$avatar2 === void 0 ? void 0 : _data$avatar2.color) || (0, _model.getUserAvatarColor)(user),
        imageUrl: ((_data$avatar3 = data.avatar) === null || _data$avatar3 === void 0 ? void 0 : _data$avatar3.imageUrl) || ''
      },
      userSettings: {
        darkMode: ((_data$userSettings = data.userSettings) === null || _data$userSettings === void 0 ? void 0 : _data$userSettings.darkMode) || 'space_default',
        contrastMode: ((_data$userSettings2 = data.userSettings) === null || _data$userSettings2 === void 0 ? void 0 : _data$userSettings2.contrastMode) || 'system'
      }
    } : undefined,
    avatarType: data !== null && data !== void 0 && (_data$avatar4 = data.avatar) !== null && _data$avatar4 !== void 0 && _data$avatar4.imageUrl ? 'image' : 'initials'
  });
  const [validateOnBlurOrChange, setValidateOnBlurOrChange] = (0, _react2.useState)(false);
  const formik = (0, _formik.useFormik)({
    onSubmit: async values => {
      var _initialValues$data, _values$data, _initialValues$data2, _values$data2;
      const submitActions = [];
      if ((0, _model.canUserChangeDetails)(user, services.application.capabilities)) {
        submitActions.push(users.saveUser({
          username: user.username,
          roles: user.roles,
          enabled: user.enabled,
          full_name: values.user.full_name,
          email: values.user.email
        }));
      }

      // Update profile only if it's available for the current user.
      if (values.data) {
        submitActions.push(update(values.avatarType === 'image' ? values.data : {
          ...values.data,
          avatar: {
            ...values.data.avatar,
            imageUrl: null
          }
        }));
      }
      if (submitActions.length === 0) {
        return;
      }
      try {
        await Promise.all(submitActions);
      } catch (error) {
        services.notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.security.accountManagement.userProfile.submitErrorTitle', {
            defaultMessage: "Couldn't update profile"
          })
        });
        return;
      }
      resetInitialValues(values);
      let isRefreshRequired = false;
      if (((_initialValues$data = initialValues.data) === null || _initialValues$data === void 0 ? void 0 : _initialValues$data.userSettings.darkMode) !== ((_values$data = values.data) === null || _values$data === void 0 ? void 0 : _values$data.userSettings.darkMode) || ((_initialValues$data2 = initialValues.data) === null || _initialValues$data2 === void 0 ? void 0 : _initialValues$data2.userSettings.contrastMode) !== ((_values$data2 = values.data) === null || _values$data2 === void 0 ? void 0 : _values$data2.userSettings.contrastMode)) {
        isRefreshRequired = true;
      }
      showSuccessNotification({
        isRefreshRequired
      });
    },
    initialValues,
    enableReinitialize: true,
    validateOnBlur: validateOnBlurOrChange,
    validateOnChange: validateOnBlurOrChange
  });

  // We perform _the first_ validation only when the user submits the form to make UX less annoying. But after the user
  // submits the form, the validation model changes to on blur/change (as the user's mindset has changed from completing
  // the form to correcting the form).
  if (formik.submitCount > 0 && !validateOnBlurOrChange) {
    setValidateOnBlurOrChange(true);
  } else if (formik.submitCount === 0 && validateOnBlurOrChange) {
    setValidateOnBlurOrChange(false);
  }
  const customAvatarInitials = (0, _react2.useRef)(!!(data !== null && data !== void 0 && (_data$avatar5 = data.avatar) !== null && _data$avatar5 !== void 0 && _data$avatar5.initials) && ((_data$avatar6 = data.avatar) === null || _data$avatar6 === void 0 ? void 0 : _data$avatar6.initials) !== (0, _model.getUserAvatarInitials)(user));
  (0, _useUpdateEffect.default)(() => {
    if (!customAvatarInitials.current) {
      const defaultInitials = (0, _model.getUserAvatarInitials)({
        username: user.username,
        full_name: formik.values.user.full_name
      });
      formik.setFieldValue('data.avatar.initials', defaultInitials);
    }
  }, [formik.values.user.full_name]);
  (0, _useUpdateEffect.default)(() => {
    if (!customAvatarInitials.current && formik.values.data) {
      const defaultInitials = (0, _model.getUserAvatarInitials)({
        username: user.username,
        full_name: formik.values.user.full_name
      });
      customAvatarInitials.current = formik.values.data.avatar.initials !== defaultInitials;
    }
  }, [(_formik$values$data = formik.values.data) === null || _formik$values$data === void 0 ? void 0 : _formik$values$data.avatar.initials]);
  return formik;
}
const SaveChangesBottomBar = () => {
  const formik = (0, _formik.useFormikContext)();
  const {
    count
  } = (0, _securityFormComponents.useFormChangesContext)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: {
      width: '100%'
    },
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1088,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1089,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1090,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1091,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "dot",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1092,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1094,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.unsavedChangesMessage",
    defaultMessage: "{count, plural, one {# unsaved change} other {# unsaved changes}}",
    values: {
      count
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1095,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: formik.handleReset,
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.discardChangesButton",
    defaultMessage: "Discard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1105,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    onClick: formik.submitForm,
    "data-test-subj": "saveProfileChangesButton",
    isLoading: formik.isSubmitting,
    isDisabled: formik.submitCount > 0 && !formik.isValid,
    color: "primary",
    iconType: "save",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.userProfile.saveChangesButton",
    defaultMessage: "{isSubmitting, select, true{Saving changes\u2026} other{Save changes}}",
    values: {
      isSubmitting: formik.isSubmitting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1121,
      columnNumber: 11
    }
  }))));
};
exports.SaveChangesBottomBar = SaveChangesBottomBar;
function determineIfThemeOverridden(settingsClient, theme) {
  return {
    isThemeOverridden: settingsClient.isOverridden('theme:darkMode'),
    isOverriddenThemeDarkMode: theme.getTheme().darkMode
  };
}