"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForParseErrors = checkForParseErrors;
var _public = require("@kbn/es-ui-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  collapseLiteralStrings
} = _public.XJson;
function checkForParseErrors(json) {
  const sanitizedJson = collapseLiteralStrings(json);
  try {
    const parsedJson = JSON.parse(sanitizedJson);
    return {
      parsed: parsedJson,
      error: null
    };
  } catch (error) {
    return {
      error,
      parsed: null
    };
  }
}