"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeQueryRuleset = exports.normalizeQueryRuleCriteria = exports.normalizeQueryRule = exports.isPermissionError = exports.isNotFoundError = exports.isCriteriaAlways = exports.formatRulesetName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isPermissionError = error => {
  return error.body.statusCode === 403;
};
exports.isPermissionError = isPermissionError;
const isNotFoundError = error => {
  return error.body.statusCode === 404;
};
exports.isNotFoundError = isNotFoundError;
const formatRulesetName = rawName => rawName.trim().replace(/[^a-zA-Z0-9]+/g, '-') // Replace all special/non-alphanumerical characters with dashes
.replace(/^[-]+|[-]+$/g, '') // Strip all leading and trailing dashes
.toLowerCase();
exports.formatRulesetName = formatRulesetName;
const isCriteriaAlways = criteria => {
  return criteria.length === 1 && criteria[0].type === 'always';
};
exports.isCriteriaAlways = isCriteriaAlways;
const normalizeQueryRuleCriteria = criteria => {
  return !Array.isArray(criteria) ? [criteria] : criteria;
};
exports.normalizeQueryRuleCriteria = normalizeQueryRuleCriteria;
const normalizeQueryRule = rule => {
  return {
    ...rule,
    criteria: normalizeQueryRuleCriteria(rule.criteria)
  };
};
exports.normalizeQueryRule = normalizeQueryRule;
const normalizeQueryRuleset = ruleset => {
  return {
    ...ruleset,
    rules: ruleset.rules.map(rule => normalizeQueryRule(rule))
  };
};
exports.normalizeQueryRuleset = normalizeQueryRuleset;